"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more builds.

    Args:
        ids(List): The IDs of the builds.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.get.build.init.batch(ctx, ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.get.build.init.batch ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="batch_get_builds",
        op_kwargs={"ids": ids},
    )
