"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def batch(hub, ctx, ids: List) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves information about one or more batch builds.

    Args:
        ids(List): An array that contains the batch build identifiers to retrieve.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.get.build.batch.batch(ctx, ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.get.build.batch.batch ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="batch_get_build_batches",
        op_kwargs={"ids": ids},
    )
