"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(
    hub,
    ctx,
    report_arn: str,
    next_token: str = None,
    max_results: int = None,
    sort_order: str = None,
    sort_by: str = None,
    min_line_coverage_percentage: float = None,
    max_line_coverage_percentage: float = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves one or more code coverage reports.

    Args:
        report_arn(str):  The ARN of the report for which test cases are returned. .
        next_token(str, optional): The nextToken value returned from a previous call to DescribeCodeCoverages. This specifies the next item to return. To return the beginning of the list, exclude this parameter. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        sort_order(str, optional): Specifies if the results are sorted in ascending or descending order. Defaults to None.
        sort_by(str, optional): Specifies how the results are sorted. Possible values are:  FILE_PATH  The results are sorted by file path.  LINE_COVERAGE_PERCENTAGE  The results are sorted by the percentage of lines that are covered.  . Defaults to None.
        min_line_coverage_percentage(float, optional): The minimum line coverage percentage to report. Defaults to None.
        max_line_coverage_percentage(float, optional): The maximum line coverage percentage to report. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.code_coverage.describe_all(ctx, report_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.code_coverage.describe_all report_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="describe_code_coverages",
        op_kwargs={
            "reportArn": report_arn,
            "nextToken": next_token,
            "maxResults": max_results,
            "sortOrder": sort_order,
            "sortBy": sort_by,
            "minLineCoveragePercentage": min_line_coverage_percentage,
            "maxLineCoveragePercentage": max_line_coverage_percentage,
        },
    )
