"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, project_name: str, sort_order: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of build identifiers for the specified build project, with each build identifier representing a single build.

    Args:
        project_name(str): The name of the AWS CodeBuild project.
        sort_order(str, optional): The order to list results in. The results are sorted by build number, not the build identifier. Valid values include:    ASCENDING: List the build IDs in ascending order by build ID.    DESCENDING: List the build IDs in descending order by build ID.   If the project has more than 100 builds, setting the sort order will result in an error. . Defaults to None.
        next_token(str, optional): During a previous call, if there are more than 100 items in the list, only the first 100 items are returned, along with a unique string called a nextToken. To get the next batch of items in the list, call this operation again, adding the next token to the call. To get all of the items in the list, keep calling this operation with each subsequent next token that is returned, until no more next tokens are returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.for_project.list(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.for_project.list project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_builds_for_project",
        op_kwargs={
            "projectName": project_name,
            "sortOrder": sort_order,
            "nextToken": next_token,
        },
    )
