"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a batch build.

    Args:
        id_(str): The identifier of the batch build to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.batch.init.delete(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.batch.init.delete id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="delete_build_batch",
        op_kwargs={"id": id_},
    )


async def list_all(
    hub,
    ctx,
    filter_: Dict = None,
    max_results: int = None,
    sort_order: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the identifiers of your build batches in the current region.

    Args:
        filter_(Dict, optional): A BuildBatchFilter object that specifies the filters for the search. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        sort_order(str, optional): Specifies the sort order of the returned items. Valid values include:    ASCENDING: List the batch build identifiers in ascending order by identifier.    DESCENDING: List the batch build identifiers in descending order by identifier.  . Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous call to ListBuildBatches. This specifies the next item to return. To return the beginning of the list, exclude this parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.batch.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.batch.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_build_batches",
        op_kwargs={
            "filter": filter_,
            "maxResults": max_results,
            "sortOrder": sort_order,
            "nextToken": next_token,
        },
    )


async def retry(
    hub, ctx, id_: str = None, idempotency_token: str = None, retry_type: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Restarts a failed batch build. Only batch builds that have failed can be retried.

    Args:
        id_(str, optional): Specifies the identifier of the batch build to restart. Defaults to None.
        idempotency_token(str, optional): A unique, case sensitive identifier you provide to ensure the idempotency of the RetryBuildBatch request. The token is included in the RetryBuildBatch request and is valid for five minutes. If you repeat the RetryBuildBatch request with the same token, but change a parameter, AWS CodeBuild returns a parameter mismatch error. Defaults to None.
        retry_type(str, optional): Specifies the type of retry to perform. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.batch.init.retry(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.batch.init.retry
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="retry_build_batch",
        op_kwargs={
            "id": id_,
            "idempotencyToken": idempotency_token,
            "retryType": retry_type,
        },
    )


async def start(
    hub,
    ctx,
    project_name: str,
    secondary_sources_override: List = None,
    secondary_sources_version_override: List = None,
    source_version: str = None,
    artifacts_override: Dict = None,
    secondary_artifacts_override: List = None,
    environment_variables_override: List = None,
    source_type_override: str = None,
    source_location_override: str = None,
    source_auth_override: Dict = None,
    git_clone_depth_override: int = None,
    git_submodules_config_override: Dict = None,
    buildspec_override: str = None,
    insecure_ssl_override: bool = None,
    report_build_batch_status_override: bool = None,
    environment_type_override: str = None,
    image_override: str = None,
    compute_type_override: str = None,
    certificate_override: str = None,
    cache_override: Dict = None,
    service_role_override: str = None,
    privileged_mode_override: bool = None,
    build_timeout_in_minutes_override: int = None,
    queued_timeout_in_minutes_override: int = None,
    encryption_key_override: str = None,
    idempotency_token: str = None,
    logs_config_override: Dict = None,
    registry_credential_override: Dict = None,
    image_pull_credentials_type_override: str = None,
    build_batch_config_override: Dict = None,
    debug_session_enabled: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Starts a batch build for a project.

    Args:
        project_name(str): The name of the project.
        secondary_sources_override(List, optional): An array of ProjectSource objects that override the secondary sources defined in the batch build project. Defaults to None.
        secondary_sources_version_override(List, optional): An array of ProjectSourceVersion objects that override the secondary source versions in the batch build project. Defaults to None.
        source_version(str, optional): The version of the batch build input to be built, for this build only. If not specified, the latest version is used. If specified, the contents depends on the source provider:  AWS CodeCommit  The commit ID, branch, or Git tag to use.  GitHub  The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a pull request ID is specified, it must use the format pr/pull-request-ID (for example pr/25). If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.  Bitbucket  The commit ID, branch name, or tag name that corresponds to the version of the source code you want to build. If a branch name is specified, the branch's HEAD commit ID is used. If not specified, the default branch's HEAD commit ID is used.  Amazon S3  The version ID of the object that represents the build input ZIP file to use.   If sourceVersion is specified at the project level, then this sourceVersion (at the build level) takes precedence.  For more information, see Source Version Sample with CodeBuild in the AWS CodeBuild User Guide. . Defaults to None.
        artifacts_override(Dict, optional): An array of ProjectArtifacts objects that contains information about the build output artifact overrides for the build project. Defaults to None.
        secondary_artifacts_override(List, optional): An array of ProjectArtifacts objects that override the secondary artifacts defined in the batch build project. Defaults to None.
        environment_variables_override(List, optional): An array of EnvironmentVariable objects that override, or add to, the environment variables defined in the batch build project. Defaults to None.
        source_type_override(str, optional): The source input type that overrides the source input defined in the batch build project. Defaults to None.
        source_location_override(str, optional): A location that overrides, for this batch build, the source location defined in the batch build project. Defaults to None.
        source_auth_override(Dict, optional): A SourceAuth object that overrides the one defined in the batch build project. This override applies only if the build project's source is BitBucket or GitHub. Defaults to None.
        git_clone_depth_override(int, optional): The user-defined depth of history, with a minimum value of 0, that overrides, for this batch build only, any previous depth of history defined in the batch build project. Defaults to None.
        git_submodules_config_override(Dict, optional): A GitSubmodulesConfig object that overrides the Git submodules configuration for this batch build. Defaults to None.
        buildspec_override(str, optional): A buildspec file declaration that overrides, for this build only, the latest one already defined in the build project. If this value is set, it can be either an inline buildspec definition, the path to an alternate buildspec file relative to the value of the built-in CODEBUILD_SRC_DIR environment variable, or the path to an S3 bucket. The bucket must be in the same AWS Region as the build project. Specify the buildspec file using its ARN (for example, arn:aws:s3:::my-codebuild-sample2/buildspec.yml). If this value is not provided or is set to an empty string, the source code must contain a buildspec file in its root directory. For more information, see Buildspec File Name and Storage Location. . Defaults to None.
        insecure_ssl_override(bool, optional): Enable this flag to override the insecure SSL setting that is specified in the batch build project. The insecure SSL setting determines whether to ignore SSL warnings while connecting to the project source code. This override applies only if the build's source is GitHub Enterprise. Defaults to None.
        report_build_batch_status_override(bool, optional): Set to true to report to your source provider the status of a batch build's start and completion. If you use this option with a source provider other than GitHub, GitHub Enterprise, or Bitbucket, an invalidInputException is thrown.   The status of a build triggered by a webhook is always reported to your source provider.  . Defaults to None.
        environment_type_override(str, optional): A container type for this batch build that overrides the one specified in the batch build project. Defaults to None.
        image_override(str, optional): The name of an image for this batch build that overrides the one specified in the batch build project. Defaults to None.
        compute_type_override(str, optional): The name of a compute type for this batch build that overrides the one specified in the batch build project. Defaults to None.
        certificate_override(str, optional): The name of a certificate for this batch build that overrides the one specified in the batch build project. Defaults to None.
        cache_override(Dict, optional): A ProjectCache object that specifies cache overrides. Defaults to None.
        service_role_override(str, optional): The name of a service role for this batch build that overrides the one specified in the batch build project. Defaults to None.
        privileged_mode_override(bool, optional): Enable this flag to override privileged mode in the batch build project. Defaults to None.
        build_timeout_in_minutes_override(int, optional): Overrides the build timeout specified in the batch build project. Defaults to None.
        queued_timeout_in_minutes_override(int, optional): The number of minutes a batch build is allowed to be queued before it times out. Defaults to None.
        encryption_key_override(str, optional): The AWS Key Management Service (AWS KMS) customer master key (CMK) that overrides the one specified in the batch build project. The CMK key encrypts the build output artifacts.  You can use a cross-account KMS key to encrypt the build output artifacts if your service role has permission to that key.   You can specify either the Amazon Resource Name (ARN) of the CMK or, if available, the CMK's alias (using the format alias/<alias-name>). Defaults to None.
        idempotency_token(str, optional): A unique, case sensitive identifier you provide to ensure the idempotency of the StartBuildBatch request. The token is included in the StartBuildBatch request and is valid for five minutes. If you repeat the StartBuildBatch request with the same token, but change a parameter, AWS CodeBuild returns a parameter mismatch error. Defaults to None.
        logs_config_override(Dict, optional): A LogsConfig object that override the log settings defined in the batch build project. Defaults to None.
        registry_credential_override(Dict, optional): A RegistryCredential object that overrides credentials for access to a private registry. Defaults to None.
        image_pull_credentials_type_override(str, optional): The type of credentials AWS CodeBuild uses to pull images in your batch build. There are two valid values:   CODEBUILD  Specifies that AWS CodeBuild uses its own credentials. This requires that you modify your ECR repository policy to trust AWS CodeBuild's service principal.  SERVICE_ROLE  Specifies that AWS CodeBuild uses your build project's service role.    When using a cross-account or private registry image, you must use SERVICE_ROLE credentials. When using an AWS CodeBuild curated image, you must use CODEBUILD credentials. . Defaults to None.
        build_batch_config_override(Dict, optional): A BuildBatchConfigOverride object that contains batch build configuration overrides. Defaults to None.
        debug_session_enabled(bool, optional): Specifies if session debugging is enabled for this batch build. For more information, see Viewing a running build in Session Manager. Batch session debugging is not supported for matrix batch builds. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.batch.init.start(ctx, project_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.batch.init.start project_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="start_build_batch",
        op_kwargs={
            "projectName": project_name,
            "secondarySourcesOverride": secondary_sources_override,
            "secondarySourcesVersionOverride": secondary_sources_version_override,
            "sourceVersion": source_version,
            "artifactsOverride": artifacts_override,
            "secondaryArtifactsOverride": secondary_artifacts_override,
            "environmentVariablesOverride": environment_variables_override,
            "sourceTypeOverride": source_type_override,
            "sourceLocationOverride": source_location_override,
            "sourceAuthOverride": source_auth_override,
            "gitCloneDepthOverride": git_clone_depth_override,
            "gitSubmodulesConfigOverride": git_submodules_config_override,
            "buildspecOverride": buildspec_override,
            "insecureSslOverride": insecure_ssl_override,
            "reportBuildBatchStatusOverride": report_build_batch_status_override,
            "environmentTypeOverride": environment_type_override,
            "imageOverride": image_override,
            "computeTypeOverride": compute_type_override,
            "certificateOverride": certificate_override,
            "cacheOverride": cache_override,
            "serviceRoleOverride": service_role_override,
            "privilegedModeOverride": privileged_mode_override,
            "buildTimeoutInMinutesOverride": build_timeout_in_minutes_override,
            "queuedTimeoutInMinutesOverride": queued_timeout_in_minutes_override,
            "encryptionKeyOverride": encryption_key_override,
            "idempotencyToken": idempotency_token,
            "logsConfigOverride": logs_config_override,
            "registryCredentialOverride": registry_credential_override,
            "imagePullCredentialsTypeOverride": image_pull_credentials_type_override,
            "buildBatchConfigOverride": build_batch_config_override,
            "debugSessionEnabled": debug_session_enabled,
        },
    )


async def stop(hub, ctx, id_: str) -> Dict:
    r"""
    **Autogenerated function**

    Stops a running batch build.

    Args:
        id_(str): The identifier of the batch build to stop.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.batch.init.stop(ctx, id_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.batch.init.stop id_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="stop_build_batch",
        op_kwargs={"id": id_},
    )
