"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub,
    ctx,
    project_name: str = None,
    filter_: Dict = None,
    max_results: int = None,
    sort_order: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the identifiers of the build batches for a specific project.

    Args:
        project_name(str, optional): The name of the project. Defaults to None.
        filter_(Dict, optional): A BuildBatchFilter object that specifies the filters for the search. Defaults to None.
        max_results(int, optional): The maximum number of results to return. Defaults to None.
        sort_order(str, optional): Specifies the sort order of the returned items. Valid values include:    ASCENDING: List the batch build identifiers in ascending order by identifier.    DESCENDING: List the batch build identifiers in descending order by identifier.  . Defaults to None.
        next_token(str, optional): The nextToken value returned from a previous call to ListBuildBatchesForProject. This specifies the next item to return. To return the beginning of the list, exclude this parameter. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codebuild.build.batch.for_project.list(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codebuild.build.batch.for_project.list
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codebuild",
        operation="list_build_batches_for_project",
        op_kwargs={
            "projectName": project_name,
            "filter": filter_,
            "maxResults": max_results,
            "sortOrder": sort_order,
            "nextToken": next_token,
        },
    )
