"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub,
    ctx,
    domain: str,
    repository: str,
    domain_owner: str = None,
    policy_revision: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Deletes the resource policy that is set on a repository. After a resource policy is deleted, the permissions allowed and denied by the deleted policy are removed. The effect of deleting a resource policy might not be immediate.    Use DeleteRepositoryPermissionsPolicy with caution. After a policy is deleted, AWS users, roles, and accounts lose permissions to perform the repository actions granted by the deleted policy.

    Args:
        domain(str):  The name of the domain that contains the repository associated with the resource policy to be deleted. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that is associated with the resource policy to be deleted .
        policy_revision(str, optional):  The revision of the repository's resource policy to be deleted. This revision is used for optimistic locking, which prevents others from accidentally overwriting your changes to the repository's resource policy. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.permission_policy.delete(
                ctx, domain=value, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.permission_policy.delete domain=value, repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="delete_repository_permissions_policy",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "policyRevision": policy_revision,
        },
    )


async def get(hub, ctx, domain: str, repository: str, domain_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns the resource policy that is set on a repository.

    Args:
        domain(str):  The name of the domain containing the repository whose associated resource policy is to be retrieved. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository whose associated resource policy is to be retrieved. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.permission_policy.get(
                ctx, domain=value, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.permission_policy.get domain=value, repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="get_repository_permissions_policy",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
        },
    )


async def put(
    hub,
    ctx,
    domain: str,
    repository: str,
    policy_document: str,
    domain_owner: str = None,
    policy_revision: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Sets the resource policy on a repository that specifies permissions to access it.   When you call PutRepositoryPermissionsPolicy, the resource policy on the repository is ignored when evaluting permissions. This ensures that the owner of a repository cannot lock themselves out of the repository, which would prevent them from being able to update the resource policy.

    Args:
        domain(str):  The name of the domain containing the repository to set the resource policy on. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository to set the resource policy on. .
        policy_revision(str, optional):  Sets the revision of the resource policy that specifies permissions to access the repository. This revision is used for optimistic locking, which prevents others from overwriting your changes to the repository's resource policy. . Defaults to None.
        policy_document(str):  A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided repository. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.permission_policy.put(
                ctx, domain=value, repository=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.permission_policy.put domain=value, repository=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="put_repository_permissions_policy",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "policyRevision": policy_revision,
            "policyDocument": policy_document,
        },
    )
