"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain: str,
    repository: str,
    domain_owner: str = None,
    description: str = None,
    upstreams: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Creates a repository.

    Args:
        domain(str):  The name of the domain that contains the created repository. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository to create. .
        description(str, optional):  A description of the created repository. . Defaults to None.
        upstreams(List, optional):  A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see Working with upstream repositories. . Defaults to None.
        tags(List, optional): One or more tag key-value pairs for the repository. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.init.create(
                ctx, domain=value, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.init.create domain=value, repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="create_repository",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "description": description,
            "upstreams": upstreams,
            "tags": tags,
        },
    )


async def delete(
    hub, ctx, domain: str, repository: str, domain_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Deletes a repository.

    Args:
        domain(str):  The name of the domain that contains the repository to delete. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository to delete. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.init.delete(
                ctx, domain=value, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.init.delete domain=value, repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="delete_repository",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
        },
    )


async def describe(
    hub, ctx, domain: str, repository: str, domain_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a RepositoryDescription object that contains detailed information about the requested repository.

    Args:
        domain(str):  The name of the domain that contains the repository to describe. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  A string that specifies the name of the requested repository. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.init.describe(
                ctx, domain=value, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.init.describe domain=value, repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="describe_repository",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
        },
    )


async def list_all(
    hub,
    ctx,
    repository_prefix: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of RepositorySummary objects. Each RepositorySummary contains information about a repository in the specified AWS account and that matches the input parameters.

    Args:
        repository_prefix(str, optional):  A prefix used to filter returned repositories. Only repositories with names that start with repositoryPrefix are returned. Defaults to None.
        max_results(int, optional):  The maximum number of results to return per page. . Defaults to None.
        next_token(str, optional):  The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="list_repositories",
        op_kwargs={
            "repositoryPrefix": repository_prefix,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    domain: str,
    repository: str,
    domain_owner: str = None,
    description: str = None,
    upstreams: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Update the properties of a repository.

    Args:
        domain(str):  The name of the domain associated with the repository to update. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository to update. .
        description(str, optional):  An updated repository description. . Defaults to None.
        upstreams(List, optional):  A list of upstream repositories to associate with the repository. The order of the upstream repositories in the list determines their priority order when AWS CodeArtifact looks for a requested package version. For more information, see Working with upstream repositories. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.init.update(
                ctx, domain=value, repository=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.init.update domain=value, repository=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="update_repository",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "description": description,
            "upstreams": upstreams,
        },
    )
