"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, domain: str, repository: str, format_: str, domain_owner: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the endpoint of a repository for a specific package format. A repository has one endpoint for each package format:     npm     pypi     maven

    Args:
        domain(str):  The name of the domain that contains the repository. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain that contains the repository. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository. .
        format_(str):  Returns which endpoint of a repository to return. A repository has one endpoint for each package format:     npm     pypi     maven   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.repository.endpoint.get(
                ctx, domain=value, repository=value, format_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.repository.endpoint.get domain=value, repository=value, format_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="get_repository_endpoint",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
        },
    )
