"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def update(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    versions: List,
    target_status: str,
    domain_owner: str = None,
    namespace: str = None,
    version_revisions: Dict = None,
    expected_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Updates the status of one or more versions of a package.

    Args:
        domain(str):  The name of the domain that contains the repository that contains the package versions with a status to be updated. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The repository that contains the package versions with the status you want to update. .
        format_(str):  A format that specifies the type of the package with the statuses to update. The valid values are:     npm     pypi     maven   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package with the version statuses to update. .
        versions(List):  An array of strings that specify the versions of the package with the statuses to update. .
        version_revisions(Dict, optional):  A map of package versions and package version revisions. The map key is the package version (for example, 3.5.2), and the map value is the package version revision. . Defaults to None.
        expected_status(str, optional):  The package version’s expected status before it is updated. If expectedStatus is provided, the package version's status is updated only if its status at the time UpdatePackageVersionsStatus is called matches expectedStatus. . Defaults to None.
        target_status(str):  The status you want to change the package version status to. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.status.update(
                ctx,
                domain=value,
                repository=value,
                format_=value,
                package=value,
                versions=value,
                target_status=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.status.update domain=value, repository=value, format_=value, package=value, versions=value, target_status=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="update_package_versions_status",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "versions": versions,
            "versionRevisions": version_revisions,
            "expectedStatus": expected_status,
            "targetStatus": target_status,
        },
    )
