"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    package_version: str,
    domain_owner: str = None,
    namespace: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Gets the readme file or descriptive text for a package version. For packages that do not contain a readme file, CodeArtifact extracts a description from a metadata file. For example, from the <description> element in the pom.xml file of a Maven package.   The returned text might contain formatting. For example, it might contain formatting for Markdown or reStructuredText.

    Args:
        domain(str):  The name of the domain that contains the repository that contains the package version with the requested readme file. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The repository that contains the package with the requested readme file. .
        format_(str):  A format that specifies the type of the package version with the requested readme file. The valid values are:     npm     pypi     maven   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package version that contains the requested readme file. .
        package_version(str):  A string that contains the package version (for example, 3.5.2). .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.readme.get(
                ctx,
                domain=value,
                repository=value,
                format_=value,
                package=value,
                package_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.readme.get domain=value, repository=value, format_=value, package=value, package_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="get_package_version_readme",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "packageVersion": package_version,
        },
    )
