"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub,
    ctx,
    domain: str,
    source_repository: str,
    destination_repository: str,
    format_: str,
    package: str,
    domain_owner: str = None,
    namespace: str = None,
    versions: List = None,
    version_revisions: Dict = None,
    allow_overwrite: bool = None,
    include_from_upstream: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Copies package versions from one repository to another repository in the same domain.    You must specify versions or versionRevisions. You cannot specify both.

    Args:
        domain(str):  The name of the domain that contains the source and destination repositories. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        source_repository(str):  The name of the repository that contains the package versions to copy. .
        destination_repository(str):  The name of the repository into which package versions are copied. .
        format_(str):  The format of the package that is copied. The valid package types are:     npm: A Node Package Manager (npm) package.     pypi: A Python Package Index (PyPI) package.     maven: A Maven package that contains compiled code in a distributable format, such as a JAR file.   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package that is copied. .
        versions(List, optional):  The versions of the package to copy.    You must specify versions or versionRevisions. You cannot specify both.  . Defaults to None.
        version_revisions(Dict, optional):  A list of key-value pairs. The keys are package versions and the values are package version revisions. A CopyPackageVersion operation succeeds if the specified versions in the source repository match the specified package version revision.    You must specify versions or versionRevisions. You cannot specify both.  . Defaults to None.
        allow_overwrite(bool, optional):  Set to true to overwrite a package version that already exists in the destination repository. If set to false and the package version already exists in the destination repository, the package version is returned in the failedVersions field of the response with an ALREADY_EXISTS error code. . Defaults to None.
        include_from_upstream(bool, optional):  Set to true to copy packages from repositories that are upstream from the source repository to the destination repository. The default setting is false. For more information, see Working with upstream repositories. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.init.copy(
                ctx,
                domain=value,
                source_repository=value,
                destination_repository=value,
                format_=value,
                package=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.init.copy domain=value, source_repository=value, destination_repository=value, format_=value, package=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="copy_package_versions",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "sourceRepository": source_repository,
            "destinationRepository": destination_repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "versions": versions,
            "versionRevisions": version_revisions,
            "allowOverwrite": allow_overwrite,
            "includeFromUpstream": include_from_upstream,
        },
    )


async def delete_multiple(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    versions: List,
    domain_owner: str = None,
    namespace: str = None,
    expected_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Deletes one or more versions of a package. A deleted package version cannot be restored in your repository. If you want to remove a package version from your repository and be able to restore it later, set its status to Archived. Archived packages cannot be downloaded from a repository and don't show up with list package APIs (for example, ListackageVersions), but you can restore them using UpdatePackageVersionsStatus.

    Args:
        domain(str):  The name of the domain that contains the package to delete. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that contains the package versions to delete. .
        format_(str):  The format of the package versions to delete. The valid values are:     npm     pypi     maven   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package with the versions to delete. .
        versions(List):  An array of strings that specify the versions of the package to delete. .
        expected_status(str, optional):  The expected status of the package version to delete. Valid values are:     Published     Unfinished     Unlisted     Archived     Disposed   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.init.delete_multiple(
                ctx, domain=value, repository=value, format_=value, package=value, versions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.init.delete_multiple domain=value, repository=value, format_=value, package=value, versions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="delete_package_versions",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "versions": versions,
            "expectedStatus": expected_status,
        },
    )


async def describe(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    package_version: str,
    domain_owner: str = None,
    namespace: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a PackageVersionDescription object that contains information about the requested package version.

    Args:
        domain(str):  The name of the domain that contains the repository that contains the package version. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that contains the package version. .
        format_(str):  A format that specifies the type of the requested package version. The valid values are:     npm     pypi     maven   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the requested package version. .
        package_version(str):  A string that contains the package version (for example, 3.5.2). .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.init.describe(
                ctx,
                domain=value,
                repository=value,
                format_=value,
                package=value,
                package_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.init.describe domain=value, repository=value, format_=value, package=value, package_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="describe_package_version",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "packageVersion": package_version,
        },
    )


async def dispose(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    versions: List,
    domain_owner: str = None,
    namespace: str = None,
    version_revisions: Dict = None,
    expected_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Deletes the assets in package versions and sets the package versions' status to Disposed. A disposed package version cannot be restored in your repository because its assets are deleted.   To view all disposed package versions in a repository, use ListPackageVersions and set the status parameter to Disposed.   To view information about a disposed package version, use DescribePackageVersion.

    Args:
        domain(str):  The name of the domain that contains the repository you want to dispose. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that contains the package versions you want to dispose. .
        format_(str):  A format that specifies the type of package versions you want to dispose. The valid values are:     npm     pypi     maven   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package with the versions you want to dispose. .
        versions(List):  The versions of the package you want to dispose. .
        version_revisions(Dict, optional):  The revisions of the package versions you want to dispose. . Defaults to None.
        expected_status(str, optional):  The expected status of the package version to dispose. Valid values are:     Published     Unfinished     Unlisted     Archived     Disposed   . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.init.dispose(
                ctx, domain=value, repository=value, format_=value, package=value, versions=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.init.dispose domain=value, repository=value, format_=value, package=value, versions=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="dispose_package_versions",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "versions": versions,
            "versionRevisions": version_revisions,
            "expectedStatus": expected_status,
        },
    )


async def list_all(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    domain_owner: str = None,
    namespace: str = None,
    status: str = None,
    sort_by: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of PackageVersionSummary objects for package versions in a repository that match the request parameters.

    Args:
        domain(str):  The name of the domain that contains the repository that contains the returned package versions. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that contains the package. .
        format_(str):  The format of the returned packages. The valid package types are:     npm: A Node Package Manager (npm) package.     pypi: A Python Package Index (PyPI) package.     maven: A Maven package that contains compiled code in a distributable format, such as a JAR file.   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package for which you want to return a list of package versions. .
        status(str, optional):  A string that specifies the status of the package versions to include in the returned list. It can be one of the following:     Published     Unfinished     Unlisted     Archived     Disposed   . Defaults to None.
        sort_by(str, optional):  How to sort the returned list of package versions. . Defaults to None.
        max_results(int, optional):  The maximum number of results to return per page. . Defaults to None.
        next_token(str, optional):  The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.init.list_all(
                ctx, domain=value, repository=value, format_=value, package=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.init.list_all domain=value, repository=value, format_=value, package=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="list_package_versions",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "status": status,
            "sortBy": sort_by,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
