"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    package_version: str,
    domain_owner: str = None,
    namespace: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns the direct dependencies for a package version. The dependencies are returned as PackageDependency objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the package.json file for npm packages and the pom.xml file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.

    Args:
        domain(str):  The name of the domain that contains the repository that contains the requested package version dependencies. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that contains the requested package version. .
        format_(str):  The format of the package with the requested dependencies. The valid package types are:     npm: A Node Package Manager (npm) package.     pypi: A Python Package Index (PyPI) package.     maven: A Maven package that contains compiled code in a distributable format, such as a JAR file.   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package versions' package. .
        package_version(str):  A string that contains the package version (for example, 3.5.2). .
        next_token(str, optional):  The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.dependency.list_all(
                ctx,
                domain=value,
                repository=value,
                format_=value,
                package=value,
                package_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.dependency.list_all domain=value, repository=value, format_=value, package=value, package_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="list_package_version_dependencies",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "packageVersion": package_version,
            "nextToken": next_token,
        },
    )
