"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    package_version: str,
    asset: str,
    domain_owner: str = None,
    namespace: str = None,
    package_version_revision: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns an asset (or file) that is in a package. For example, for a Maven package version, use GetPackageVersionAsset to download a JAR file, a POM file, or any other assets in the package version.

    Args:
        domain(str):  The name of the domain that contains the repository that contains the package version with the requested asset. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The repository that contains the package version with the requested asset. .
        format_(str):  A format that specifies the type of the package version with the requested asset file. The valid values are:     npm     pypi     maven   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package that contains the requested asset. .
        package_version(str):  A string that contains the package version (for example, 3.5.2). .
        asset(str):  The name of the requested asset. .
        package_version_revision(str, optional):  The name of the package version revision that contains the requested asset. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.asset.get(
                ctx,
                domain=value,
                repository=value,
                format_=value,
                package=value,
                package_version=value,
                asset=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.asset.get domain=value, repository=value, format_=value, package=value, package_version=value, asset=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="get_package_version_asset",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "packageVersion": package_version,
            "asset": asset,
            "packageVersionRevision": package_version_revision,
        },
    )


async def list_all(
    hub,
    ctx,
    domain: str,
    repository: str,
    format_: str,
    package: str,
    package_version: str,
    domain_owner: str = None,
    namespace: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Returns a list of AssetSummary objects for assets in a package version.

    Args:
        domain(str):  The name of the domain that contains the repository associated with the package version assets. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository that contains the package that contains the returned package version assets. .
        format_(str):  The format of the package that contains the returned package version assets. The valid package types are:     npm: A Node Package Manager (npm) package.     pypi: A Python Package Index (PyPI) package.     maven: A Maven package that contains compiled code in a distributable format, such as a JAR file.   .
        namespace(str, optional):  The namespace of the package. The package component that specifies its namespace depends on its type. For example:     The namespace of a Maven package is its groupId.     The namespace of an npm package is its scope.     A Python package does not contain a corresponding component, so Python packages do not have a namespace.   . Defaults to None.
        package(str):  The name of the package that contains the returned package version assets. .
        package_version(str):  A string that contains the package version (for example, 3.5.2). .
        max_results(int, optional):  The maximum number of results to return per page. . Defaults to None.
        next_token(str, optional):  The token for the next set of results. Use the value returned in the previous response in the next request to retrieve the next set of results. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.package.version.asset.list_all(
                ctx,
                domain=value,
                repository=value,
                format_=value,
                package=value,
                package_version=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.package.version.asset.list_all domain=value, repository=value, format_=value, package=value, package_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="list_package_version_assets",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "format": format_,
            "namespace": namespace,
            "package": package,
            "packageVersion": package_version,
            "maxResults": max_results,
            "nextToken": next_token,
        },
    )
