"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def associate(
    hub,
    ctx,
    domain: str,
    repository: str,
    external_connection: str,
    domain_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds an existing external connection to a repository. One external connection is allowed per repository.  A repository can have one or more upstream repositories, or an external connection.

    Args:
        domain(str): The name of the domain that contains the repository.
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str):  The name of the repository to which the external connection is added. .
        external_connection(str):  The name of the external connection to add to the repository. The following values are supported:     public:npmjs - for the npm public repository.     public:pypi - for the Python Package Index.     public:maven-central - for Maven Central.     public:maven-googleandroid - for the Google Android repository.     public:maven-gradleplugins - for the Gradle plugins repository.     public:maven-commonsware - for the CommonsWare Android repository.   .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.external_connection.associate(
                ctx, domain=value, repository=value, external_connection=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.external_connection.associate domain=value, repository=value, external_connection=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="associate_external_connection",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "externalConnection": external_connection,
        },
    )


async def disassociate(
    hub,
    ctx,
    domain: str,
    repository: str,
    external_connection: str,
    domain_owner: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Removes an existing external connection from a repository.

    Args:
        domain(str): The name of the domain that contains the repository from which to remove the external repository. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        repository(str): The name of the repository from which the external connection will be removed. .
        external_connection(str): The name of the external connection to be removed from the repository. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.external_connection.disassociate(
                ctx, domain=value, repository=value, external_connection=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.external_connection.disassociate domain=value, repository=value, external_connection=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="disassociate_external_connection",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "repository": repository,
            "externalConnection": external_connection,
        },
    )
