"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(
    hub, ctx, domain: str, domain_owner: str = None, policy_revision: str = None
) -> Dict:
    r"""
    **Autogenerated function**

     Deletes the resource policy set on a domain.

    Args:
        domain(str):  The name of the domain associated with the resource policy to be deleted. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        policy_revision(str, optional):  The current revision of the resource policy to be deleted. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.domain.permission_policy.delete(ctx, domain=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.domain.permission_policy.delete domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="delete_domain_permissions_policy",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "policyRevision": policy_revision,
        },
    )


async def get(hub, ctx, domain: str, domain_owner: str = None) -> Dict:
    r"""
    **Autogenerated function**

     Returns the resource policy attached to the specified domain.    The policy is a resource-based policy, not an identity-based policy. For more information, see Identity-based policies and resource-based policies  in the AWS Identity and Access Management User Guide.

    Args:
        domain(str):  The name of the domain to which the resource policy is attached. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.domain.permission_policy.get(ctx, domain=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.domain.permission_policy.get domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="get_domain_permissions_policy",
        op_kwargs={"domain": domain, "domainOwner": domain_owner},
    )


async def put(
    hub,
    ctx,
    domain: str,
    policy_document: str,
    domain_owner: str = None,
    policy_revision: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

     Sets a resource policy on a domain that specifies permissions to access it.   When you call PutDomainPermissionsPolicy, the resource policy on the domain is ignored when evaluting permissions. This ensures that the owner of a domain cannot lock themselves out of the domain, which would prevent them from being able to update the resource policy.

    Args:
        domain(str):  The name of the domain on which to set the resource policy. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        policy_revision(str, optional):  The current revision of the resource policy to be set. This revision is used for optimistic locking, which prevents others from overwriting your changes to the domain's resource policy. . Defaults to None.
        policy_document(str):  A valid displayable JSON Aspen policy string to be set as the access control resource policy on the provided domain. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.domain.permission_policy.put(
                ctx, domain=value, policy_document=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.domain.permission_policy.put domain=value, policy_document=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="put_domain_permissions_policy",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "policyRevision": policy_revision,
            "policyDocument": policy_document,
        },
    )
