"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, domain: str, domain_owner: str = None, duration_seconds: int = None
) -> Dict:
    r"""
    **Autogenerated function**

     Generates a temporary authorization token for accessing repositories in the domain. This API requires the codeartifact:GetAuthorizationToken and sts:GetServiceBearerToken permissions. For more information about authorization tokens, see AWS CodeArtifact authentication and tokens.   CodeArtifact authorization tokens are valid for a period of 12 hours when created with the login command. You can call login periodically to refresh the token. When you create an authorization token with the GetAuthorizationToken API, you can set a custom authorization period, up to a maximum of 12 hours, with the durationSeconds parameter. The authorization period begins after login or GetAuthorizationToken is called. If login or GetAuthorizationToken is called while assuming a role, the token lifetime is independent of the maximum session duration of the role. For example, if you call sts assume-role and specify a session duration of 15 minutes, then generate a CodeArtifact authorization token, the token will be valid for the full authorization period even though this is longer than the 15-minute session duration. See Using IAM Roles for more information on controlling session duration.

    Args:
        domain(str):  The name of the domain that is in scope for the generated authorization token. .
        domain_owner(str, optional):  The 12-digit account number of the AWS account that owns the domain. It does not include dashes or spaces. . Defaults to None.
        duration_seconds(int, optional): The time, in seconds, that the generated authorization token is valid. Valid values are 0 and any number between 900 (15 minutes) and 43200 (12 hours). A value of 0 will set the expiration of the authorization token to the same expiration of the user's role's temporary credentials. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.codeartifact.authorization_token.get(ctx, domain=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.codeartifact.authorization_token.get domain=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="codeartifact",
        operation="get_authorization_token",
        op_kwargs={
            "domain": domain,
            "domainOwner": domain_owner,
            "durationSeconds": duration_seconds,
        },
    )
