"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, metric_widget: str, output_format: str = None) -> Dict:
    r"""
    **Autogenerated function**

    You can use the GetMetricWidgetImage API to retrieve a snapshot graph of one or more Amazon CloudWatch metrics as a bitmap image. You can then embed this image into your services and products, such as wiki pages, reports, and documents. You could also retrieve images regularly, such as every minute, and create your own custom live dashboard. The graph you retrieve can include all CloudWatch metric graph features, including metric math and horizontal and vertical annotations. There is a limit of 20 transactions per second for this API. Each GetMetricWidgetImage action has the following limits:   As many as 100 metrics in the graph.   Up to 100 KB uncompressed payload.

    Args:
        metric_widget(str): A JSON string that defines the bitmap graph to be retrieved. The string includes the metrics to include in the graph, statistics, annotations, title, axis limits, and so on. You can include only one MetricWidget parameter in each GetMetricWidgetImage call. For more information about the syntax of MetricWidget see GetMetricWidgetImage: Metric Widget Structure and Syntax. If any metric on the graph could not load all the requested data points, an orange triangle with an exclamation point appears next to the graph legend.
        output_format(str, optional): The format of the resulting image. Only PNG images are supported. The default is png. If you specify png, the API returns an HTTP response with the content-type set to text/xml. The image data is in a MetricWidgetImage field. For example:   <GetMetricWidgetImageResponse xmlns=<URLstring>>    <GetMetricWidgetImageResult>    <MetricWidgetImage>    iVBORw0KGgoAAAANSUhEUgAAAlgAAAGQEAYAAAAip...    </MetricWidgetImage>    </GetMetricWidgetImageResult>    <ResponseMetadata>    <RequestId>6f0d4192-4d42-11e8-82c1-f539a07e0e3b</RequestId>    </ResponseMetadata>   </GetMetricWidgetImageResponse>  The image/png setting is intended only for custom HTTP requests. For most use cases, and all actions using an Amazon Web Services SDK, you should use png. If you specify image/png, the HTTP response has a content-type set to image/png, and the body of the response is a PNG image. . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.widget_image.get(ctx, metric_widget=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.widget_image.get metric_widget=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="get_metric_widget_image",
        op_kwargs={"MetricWidget": metric_widget, "OutputFormat": output_format},
    )
