"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently deletes the metric stream that you specify.

    Args:
        name(str): The name of the metric stream to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.stream.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.stream.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="delete_metric_stream",
        op_kwargs={"Name": name},
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about the metric stream that you specify.

    Args:
        name(str): The name of the metric stream to retrieve information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.stream.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.stream.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="get_metric_stream",
        op_kwargs={"Name": name},
    )


async def list_all(hub, ctx, next_token: str = None, max_results: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of metric streams in this account.

    Args:
        next_token(str, optional): Include this value, if it was returned by the previous call, to get the next set of metric streams. Defaults to None.
        max_results(int, optional): The maximum number of results to return in one operation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.stream.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.stream.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="list_metric_streams",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def put(
    hub,
    ctx,
    name: str,
    firehose_arn: str,
    role_arn: str,
    output_format: str,
    include_filters: List = None,
    exclude_filters: List = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates or updates a metric stream. Metric streams can automatically stream CloudWatch metrics to Amazon Web Services destinations including Amazon S3 and to many third-party solutions. For more information, see  Using Metric Streams. To create a metric stream, you must be logged on to an account that has the iam:PassRole permission and either the CloudWatchFullAccess policy or the cloudwatch:PutMetricStream permission. When you create or update a metric stream, you choose one of the following:   Stream metrics from all metric namespaces in the account.   Stream metrics from all metric namespaces in the account, except for the namespaces that you list in ExcludeFilters.   Stream metrics from only the metric namespaces that you list in IncludeFilters.   When you use PutMetricStream to create a new metric stream, the stream is created in the running state. If you use it to update an existing stream, the state of the stream is not changed.

    Args:
        name(str): If you are creating a new metric stream, this is the name for the new stream. The name must be different than the names of other metric streams in this account and Region. If you are updating a metric stream, specify the name of that stream here. Valid characters are A-Z, a-z, 0-9, "-" and "_".
        include_filters(List, optional): If you specify this parameter, the stream sends only the metrics from the metric namespaces that you specify here. You cannot include IncludeFilters and ExcludeFilters in the same operation. Defaults to None.
        exclude_filters(List, optional): If you specify this parameter, the stream sends metrics from all metric namespaces except for the namespaces that you specify here. You cannot include ExcludeFilters and IncludeFilters in the same operation. Defaults to None.
        firehose_arn(str): The ARN of the Amazon Kinesis Firehose delivery stream to use for this metric stream. This Amazon Kinesis Firehose delivery stream must already exist and must be in the same account as the metric stream.
        role_arn(str): The ARN of an IAM role that this metric stream will use to access Amazon Kinesis Firehose resources. This IAM role must already exist and must be in the same account as the metric stream. This IAM role must include the following permissions:   firehose:PutRecord   firehose:PutRecordBatch  .
        output_format(str): The output format for the stream. Valid values are json and opentelemetry0.7. For more information about metric stream output formats, see  Metric streams output formats.
        tags(List, optional): A list of key-value pairs to associate with the metric stream. You can associate as many as 50 tags with a metric stream. Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values. You can use this parameter only when you are creating a new metric stream. If you are using this operation to update an existing metric stream, any tags you specify in this parameter are ignored. To change the tags of an existing metric stream, use TagResource or UntagResource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.stream.put(
                ctx, name=value, firehose_arn=value, role_arn=value, output_format=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.stream.put name=value, firehose_arn=value, role_arn=value, output_format=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="put_metric_stream",
        op_kwargs={
            "Name": name,
            "IncludeFilters": include_filters,
            "ExcludeFilters": exclude_filters,
            "FirehoseArn": firehose_arn,
            "RoleArn": role_arn,
            "OutputFormat": output_format,
            "Tags": tags,
        },
    )


async def start(hub, ctx, names: List) -> Dict:
    r"""
    **Autogenerated function**

    Starts the streaming of metrics for one or more of your metric streams.

    Args:
        names(List): The array of the names of metric streams to start streaming. This is an "all or nothing" operation. If you do not have permission to access all of the metric streams that you list here, then none of the streams that you list in the operation will start streaming.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.stream.start(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.stream.start names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="start_metric_streams",
        op_kwargs={"Names": names},
    )


async def stop(hub, ctx, names: List) -> Dict:
    r"""
    **Autogenerated function**

    Stops the streaming of metrics for one or more of your metric streams.

    Args:
        names(List): The array of the names of metric streams to stop streaming. This is an "all or nothing" operation. If you do not have permission to access all of the metric streams that you list here, then none of the streams that you list in the operation will stop streaming.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.stream.stop(ctx, names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.stream.stop names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="stop_metric_streams",
        op_kwargs={"Names": names},
    )
