"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def list_all(
    hub,
    ctx,
    namespace: str = None,
    metric_name: str = None,
    dimensions: List = None,
    next_token: str = None,
    recently_active: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    List the specified metrics. You can use the returned metrics with GetMetricData or GetMetricStatistics to obtain statistical data. Up to 500 results are returned for any one call. To retrieve additional results, use the returned token with subsequent calls. After you create a metric, allow up to 15 minutes before the metric appears. You can see statistics about the metric sooner by using GetMetricData or GetMetricStatistics.  ListMetrics doesn't return information about metrics if those metrics haven't reported data in the past two weeks. To retrieve those metrics, use GetMetricData or GetMetricStatistics.

    Args:
        namespace(str, optional): The metric namespace to filter against. Only the namespace that matches exactly will be returned. Defaults to None.
        metric_name(str, optional): The name of the metric to filter against. Only the metrics with names that match exactly will be returned. Defaults to None.
        dimensions(List, optional): The dimensions to filter against. Only the dimensions that match exactly will be returned. Defaults to None.
        next_token(str, optional): The token returned by a previous call to indicate that there is more data available. Defaults to None.
        recently_active(str, optional): To filter the results to show only metrics that have had data points published in the past three hours, specify this parameter with a value of PT3H. This is the only valid value for this parameter. The results that are returned are an approximation of the value you specify. There is a low probability that the returned results include metrics with last published data as much as 40 minutes more than the specified time interval. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.metric.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.metric.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="list_metrics",
        op_kwargs={
            "Namespace": namespace,
            "MetricName": metric_name,
            "Dimensions": dimensions,
            "NextToken": next_token,
            "RecentlyActive": recently_active,
        },
    )
