"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, rule_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Permanently deletes the specified Contributor Insights rules. If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.

    Args:
        rule_names(List): An array of the rule names to delete. If you need to find out the names of your rules, use DescribeInsightRules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.insight_rule.init.delete_multiple(
                ctx, rule_names=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.insight_rule.init.delete_multiple rule_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="delete_insight_rules",
        op_kwargs={"RuleNames": rule_names},
    )


async def describe_all(
    hub, ctx, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of all the Contributor Insights rules in your account. For more information about Contributor Insights, see Using Contributor Insights to Analyze High-Cardinality Data.

    Args:
        next_token(str, optional): Include this value, if it was returned by the previous operation, to get the next set of rules. Defaults to None.
        max_results(int, optional): The maximum number of results to return in one operation. If you omit this parameter, the default of 500 is used. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.insight_rule.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.insight_rule.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="describe_insight_rules",
        op_kwargs={"NextToken": next_token, "MaxResults": max_results},
    )


async def disable(hub, ctx, rule_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Disables the specified Contributor Insights rules. When rules are disabled, they do not analyze log groups and do not incur costs.

    Args:
        rule_names(List): An array of the rule names to disable. If you need to find out the names of your rules, use DescribeInsightRules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.insight_rule.init.disable(ctx, rule_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.insight_rule.init.disable rule_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="disable_insight_rules",
        op_kwargs={"RuleNames": rule_names},
    )


async def enable(hub, ctx, rule_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Enables the specified Contributor Insights rules. When rules are enabled, they immediately begin analyzing log data.

    Args:
        rule_names(List): An array of the rule names to enable. If you need to find out the names of your rules, use DescribeInsightRules.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.insight_rule.init.enable(ctx, rule_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.insight_rule.init.enable rule_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="enable_insight_rules",
        op_kwargs={"RuleNames": rule_names},
    )


async def put(
    hub,
    ctx,
    rule_name: str,
    rule_definition: str,
    rule_state: str = None,
    tags: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Contributor Insights rule. Rules evaluate log events in a CloudWatch Logs log group, enabling you to find contributor data for the log events in that log group. For more information, see Using Contributor Insights to Analyze High-Cardinality Data. If you create a rule, delete it, and then re-create it with the same name, historical data from the first time the rule was created might not be available.

    Args:
        rule_name(str): A unique name for the rule.
        rule_state(str, optional): The state of the rule. Valid values are ENABLED and DISABLED. Defaults to None.
        rule_definition(str): The definition of the rule, as a JSON object. For details on the valid syntax, see Contributor Insights Rule Syntax.
        tags(List, optional): A list of key-value pairs to associate with the Contributor Insights rule. You can associate as many as 50 tags with a rule. Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only the resources that have certain tag values. To be able to associate tags with a rule, you must have the cloudwatch:TagResource permission in addition to the cloudwatch:PutInsightRule permission. If you are using this operation to update an existing Contributor Insights rule, any tags you specify in this parameter are ignored. To change the tags of an existing rule, use TagResource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.insight_rule.init.put(
                ctx, rule_name=value, rule_definition=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.insight_rule.init.put rule_name=value, rule_definition=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="put_insight_rule",
        op_kwargs={
            "RuleName": rule_name,
            "RuleState": rule_state,
            "RuleDefinition": rule_definition,
            "Tags": tags,
        },
    )
