"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, dashboard_names: List) -> Dict:
    r"""
    **Autogenerated function**

    Deletes all dashboards that you specify. You can specify up to 100 dashboards to delete. If there is an error during this call, no dashboards are deleted.

    Args:
        dashboard_names(List): The dashboards to be deleted. This parameter is required.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.dashboard.delete_multiple(ctx, dashboard_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.dashboard.delete_multiple dashboard_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="delete_dashboards",
        op_kwargs={"DashboardNames": dashboard_names},
    )


async def get(hub, ctx, dashboard_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Displays the details of the dashboard that you specify. To copy an existing dashboard, use GetDashboard, and then use the data returned within DashboardBody as the template for the new dashboard when you call PutDashboard to create the copy.

    Args:
        dashboard_name(str): The name of the dashboard to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.dashboard.get(ctx, dashboard_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.dashboard.get dashboard_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="get_dashboard",
        op_kwargs={"DashboardName": dashboard_name},
    )


async def list_all(
    hub, ctx, dashboard_name_prefix: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns a list of the dashboards for your account. If you include DashboardNamePrefix, only those dashboards with names starting with the prefix are listed. Otherwise, all dashboards in your account are listed.   ListDashboards returns up to 1000 results on one page. If there are more than 1000 dashboards, you can call ListDashboards again and include the value you received for NextToken in the first call, to receive the next 1000 results.

    Args:
        dashboard_name_prefix(str, optional): If you specify this parameter, only the dashboards with names starting with the specified string are listed. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, ".", "-", and "_". . Defaults to None.
        next_token(str, optional): The token returned by a previous call to indicate that there is more data available. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.dashboard.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.dashboard.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="list_dashboards",
        op_kwargs={
            "DashboardNamePrefix": dashboard_name_prefix,
            "NextToken": next_token,
        },
    )


async def put(hub, ctx, dashboard_name: str, dashboard_body: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a dashboard if it does not already exist, or updates an existing dashboard. If you update a dashboard, the entire contents are replaced with what you specify here. All dashboards in your account are global, not region-specific. A simple way to create a dashboard using PutDashboard is to copy an existing dashboard. To copy an existing dashboard using the console, you can load the dashboard and then use the View/edit source command in the Actions menu to display the JSON block for that dashboard. Another way to copy a dashboard is to use GetDashboard, and then use the data returned within DashboardBody as the template for the new dashboard when you call PutDashboard. When you create a dashboard with PutDashboard, a good practice is to add a text widget at the top of the dashboard with a message that the dashboard was created by script and should not be changed in the console. This message could also point console users to the location of the DashboardBody script or the CloudFormation template used to create the dashboard.

    Args:
        dashboard_name(str): The name of the dashboard. If a dashboard with this name already exists, this call modifies that dashboard, replacing its current contents. Otherwise, a new dashboard is created. The maximum length is 255, and valid characters are A-Z, a-z, 0-9, "-", and "_". This parameter is required.
        dashboard_body(str): The detailed information about the dashboard in JSON format, including the widgets to include and their location on the dashboard. This parameter is required. For more information about the syntax, see Dashboard Body Structure and Syntax.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.dashboard.put(
                ctx, dashboard_name=value, dashboard_body=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.dashboard.put dashboard_name=value, dashboard_body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="put_dashboard",
        op_kwargs={"DashboardName": dashboard_name, "DashboardBody": dashboard_body},
    )
