"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, namespace: str, metric_name: str, stat: str, dimensions: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified anomaly detection model from your account.

    Args:
        namespace(str): The namespace associated with the anomaly detection model to delete.
        metric_name(str): The metric name associated with the anomaly detection model to delete.
        dimensions(List, optional): The metric dimensions associated with the anomaly detection model to delete. Defaults to None.
        stat(str): The statistic associated with the anomaly detection model to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.anomaly_detector.delete(
                ctx, namespace=value, metric_name=value, stat=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.anomaly_detector.delete namespace=value, metric_name=value, stat=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="delete_anomaly_detector",
        op_kwargs={
            "Namespace": namespace,
            "MetricName": metric_name,
            "Dimensions": dimensions,
            "Stat": stat,
        },
    )


async def describe_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    namespace: str = None,
    metric_name: str = None,
    dimensions: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the anomaly detection models that you have created in your account. You can list all models in your account or filter the results to only the models that are related to a certain namespace, metric name, or metric dimension.

    Args:
        next_token(str, optional): Use the token returned by the previous operation to request the next page of results. Defaults to None.
        max_results(int, optional): The maximum number of results to return in one operation. The maximum value that you can specify is 100. To retrieve the remaining results, make another call with the returned NextToken value. . Defaults to None.
        namespace(str, optional): Limits the results to only the anomaly detection models that are associated with the specified namespace. Defaults to None.
        metric_name(str, optional): Limits the results to only the anomaly detection models that are associated with the specified metric name. If there are multiple metrics with this name in different namespaces that have anomaly detection models, they're all returned. Defaults to None.
        dimensions(List, optional): Limits the results to only the anomaly detection models that are associated with the specified metric dimensions. If there are multiple metrics that have these dimensions and have anomaly detection models associated, they're all returned. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.anomaly_detector.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.anomaly_detector.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="describe_anomaly_detectors",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Namespace": namespace,
            "MetricName": metric_name,
            "Dimensions": dimensions,
        },
    )


async def put(
    hub,
    ctx,
    namespace: str,
    metric_name: str,
    stat: str,
    dimensions: List = None,
    configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an anomaly detection model for a CloudWatch metric. You can use the model to display a band of expected normal values when the metric is graphed. For more information, see CloudWatch Anomaly Detection.

    Args:
        namespace(str): The namespace of the metric to create the anomaly detection model for.
        metric_name(str): The name of the metric to create the anomaly detection model for.
        dimensions(List, optional): The metric dimensions to create the anomaly detection model for. Defaults to None.
        stat(str): The statistic to use for the metric and the anomaly detection model.
        configuration(Dict, optional): The configuration specifies details about how the anomaly detection model is to be trained, including time ranges to exclude when training and updating the model. You can specify as many as 10 time ranges. The configuration can also include the time zone to use for the metric. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.anomaly_detector.put(
                ctx, namespace=value, metric_name=value, stat=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.anomaly_detector.put namespace=value, metric_name=value, stat=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="put_anomaly_detector",
        op_kwargs={
            "Namespace": namespace,
            "MetricName": metric_name,
            "Dimensions": dimensions,
            "Stat": stat,
            "Configuration": configuration,
        },
    )
