"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


__func_alias__ = {"set_": "set"}


async def set_(
    hub,
    ctx,
    alarm_name: str,
    state_value: str,
    state_reason: str,
    state_reason_data: str = None,
) -> None:
    r"""
    **Autogenerated function**

    Temporarily sets the state of an alarm for testing purposes. When the updated state differs from the previous value, the action configured for the appropriate state is invoked. For example, if your alarm is configured to send an Amazon SNS message when an alarm is triggered, temporarily changing the alarm state to ALARM sends an SNS message. Metric alarms returns to their actual state quickly, often within seconds. Because the metric alarm state change happens quickly, it is typically only visible in the alarm's History tab in the Amazon CloudWatch console or through DescribeAlarmHistory. If you use SetAlarmState on a composite alarm, the composite alarm is not guaranteed to return to its actual state. It returns to its actual state only once any of its children alarms change state. It is also reevaluated if you update its configuration. If an alarm triggers EC2 Auto Scaling policies or application Auto Scaling policies, you must include information in the StateReasonData parameter to enable the policy to take the correct action.

    Args:
        alarm_name(str): The name of the alarm.
        state_value(str): The value of the state.
        state_reason(str): The reason that this alarm is set to this specific state, in text format.
        state_reason_data(str, optional): The reason that this alarm is set to this specific state, in JSON format. For SNS or EC2 alarm actions, this is just informational. But for EC2 Auto Scaling or application Auto Scaling alarm actions, the Auto Scaling policy uses the information in this field to take the correct action. Defaults to None.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.state.set(
                ctx, alarm_name=value, state_value=value, state_reason=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.state.set alarm_name=value, state_value=value, state_reason=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="set_alarm_state",
        op_kwargs={
            "AlarmName": alarm_name,
            "StateValue": state_value,
            "StateReason": state_reason,
            "StateReasonData": state_reason_data,
        },
    )
