"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete_multiple(hub, ctx, alarm_names: List) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified alarms. You can delete up to 100 alarms in one operation. However, this total can include no more than one composite alarm. For example, you could delete 99 metric alarms and one composite alarms with one operation, but you can't delete two composite alarms with one operation.  In the event of an error, no alarms are deleted.  It is possible to create a loop or cycle of composite alarms, where composite alarm A depends on composite alarm B, and composite alarm B also depends on composite alarm A. In this scenario, you can't delete any composite alarm that is part of the cycle because there is always still a composite alarm that depends on that alarm that you want to delete. To get out of such a situation, you must break the cycle by changing the rule of one of the composite alarms in the cycle to remove a dependency that creates the cycle. The simplest change to make to break a cycle is to change the AlarmRule of one of the alarms to False.  Additionally, the evaluation of composite alarms stops if CloudWatch detects a cycle in the evaluation path.

    Args:
        alarm_names(List): The alarms to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.init.delete_multiple(ctx, alarm_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.init.delete_multiple alarm_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="delete_alarms",
        op_kwargs={"AlarmNames": alarm_names},
    )


async def describe_all(
    hub,
    ctx,
    alarm_names: List = None,
    alarm_name_prefix: str = None,
    alarm_types: List = None,
    children_of_alarm_name: str = None,
    parents_of_alarm_name: str = None,
    state_value: str = None,
    action_prefix: str = None,
    max_records: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the specified alarms. You can filter the results by specifying a prefix for the alarm name, the alarm state, or a prefix for any action.

    Args:
        alarm_names(List, optional): The names of the alarms to retrieve information about. Defaults to None.
        alarm_name_prefix(str, optional): An alarm name prefix. If you specify this parameter, you receive information about all alarms that have names that start with this prefix. If this parameter is specified, you cannot specify AlarmNames. Defaults to None.
        alarm_types(List, optional): Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you omit this parameter, only metric alarms are returned. Defaults to None.
        children_of_alarm_name(str, optional): If you use this parameter and specify the name of a composite alarm, the operation returns information about the "children" alarms of the alarm you specify. These are the metric alarms and composite alarms referenced in the AlarmRule field of the composite alarm that you specify in ChildrenOfAlarmName. Information about the composite alarm that you name in ChildrenOfAlarmName is not returned. If you specify ChildrenOfAlarmName, you cannot specify any other parameters in the request except for MaxRecords and NextToken. If you do so, you receive a validation error.  Only the Alarm Name, ARN, StateValue (OK/ALARM/INSUFFICIENT_DATA), and StateUpdatedTimestamp information are returned by this operation when you use this parameter. To get complete information about these alarms, perform another DescribeAlarms operation and specify the parent alarm names in the AlarmNames parameter. . Defaults to None.
        parents_of_alarm_name(str, optional): If you use this parameter and specify the name of a metric or composite alarm, the operation returns information about the "parent" alarms of the alarm you specify. These are the composite alarms that have AlarmRule parameters that reference the alarm named in ParentsOfAlarmName. Information about the alarm that you specify in ParentsOfAlarmName is not returned. If you specify ParentsOfAlarmName, you cannot specify any other parameters in the request except for MaxRecords and NextToken. If you do so, you receive a validation error.  Only the Alarm Name and ARN are returned by this operation when you use this parameter. To get complete information about these alarms, perform another DescribeAlarms operation and specify the parent alarm names in the AlarmNames parameter. . Defaults to None.
        state_value(str, optional): Specify this parameter to receive information only about alarms that are currently in the state that you specify. Defaults to None.
        action_prefix(str, optional): Use this parameter to filter the results of the operation to only those alarms that use a certain alarm action. For example, you could specify the ARN of an SNS topic to find all alarms that send notifications to that topic. Defaults to None.
        max_records(int, optional): The maximum number of alarm descriptions to retrieve. Defaults to None.
        next_token(str, optional): The token returned by a previous call to indicate that there is more data available. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="describe_alarms",
        op_kwargs={
            "AlarmNames": alarm_names,
            "AlarmNamePrefix": alarm_name_prefix,
            "AlarmTypes": alarm_types,
            "ChildrenOfAlarmName": children_of_alarm_name,
            "ParentsOfAlarmName": parents_of_alarm_name,
            "StateValue": state_value,
            "ActionPrefix": action_prefix,
            "MaxRecords": max_records,
            "NextToken": next_token,
        },
    )
