"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    alarm_name: str = None,
    alarm_types: List = None,
    history_item_type: str = None,
    start_date: str = None,
    end_date: str = None,
    max_records: int = None,
    next_token: str = None,
    scan_by: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the history for the specified alarm. You can filter the results by date range or item type. If an alarm name is not specified, the histories for either all metric alarms or all composite alarms are returned. CloudWatch retains the history of an alarm even if you delete the alarm.

    Args:
        alarm_name(str, optional): The name of the alarm. Defaults to None.
        alarm_types(List, optional): Use this parameter to specify whether you want the operation to return metric alarms or composite alarms. If you omit this parameter, only metric alarms are returned. Defaults to None.
        history_item_type(str, optional): The type of alarm histories to retrieve. Defaults to None.
        start_date(str, optional): The starting date to retrieve alarm history. Defaults to None.
        end_date(str, optional): The ending date to retrieve alarm history. Defaults to None.
        max_records(int, optional): The maximum number of alarm history records to retrieve. Defaults to None.
        next_token(str, optional): The token returned by a previous call to indicate that there is more data available. Defaults to None.
        scan_by(str, optional): Specified whether to return the newest or oldest alarm history first. Specify TimestampDescending to have the newest event history returned first, and specify TimestampAscending to have the oldest history returned first. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.history.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.history.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="describe_alarm_history",
        op_kwargs={
            "AlarmName": alarm_name,
            "AlarmTypes": alarm_types,
            "HistoryItemType": history_item_type,
            "StartDate": start_date,
            "EndDate": end_date,
            "MaxRecords": max_records,
            "NextToken": next_token,
            "ScanBy": scan_by,
        },
    )
