"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def describe(
    hub,
    ctx,
    metric_name: str,
    namespace: str,
    statistic: str = None,
    extended_statistic: str = None,
    dimensions: List = None,
    period: int = None,
    unit: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves the alarms for the specified metric. To filter the results, specify a statistic, period, or unit. This operation retrieves only standard alarms that are based on the specified metric. It does not return alarms based on math expressions that use the specified metric, or composite alarms that use the specified metric.

    Args:
        metric_name(str): The name of the metric.
        namespace(str): The namespace of the metric.
        statistic(str, optional): The statistic for the metric, other than percentiles. For percentile statistics, use ExtendedStatistics. Defaults to None.
        extended_statistic(str, optional): The percentile statistic for the metric. Specify a value between p0.0 and p100. Defaults to None.
        dimensions(List, optional): The dimensions associated with the metric. If the metric has any associated dimensions, you must specify them in order for the call to succeed. Defaults to None.
        period(int, optional): The period, in seconds, over which the statistic is applied. Defaults to None.
        unit(str, optional): The unit for the metric. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.for_metric.describe(
                ctx, metric_name=value, namespace=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.for_metric.describe metric_name=value, namespace=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="describe_alarms_for_metric",
        op_kwargs={
            "MetricName": metric_name,
            "Namespace": namespace,
            "Statistic": statistic,
            "ExtendedStatistic": extended_statistic,
            "Dimensions": dimensions,
            "Period": period,
            "Unit": unit,
        },
    )
