"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import List


async def disable(hub, ctx, alarm_names: List) -> None:
    r"""
    **Autogenerated function**

    Disables the actions for the specified alarms. When an alarm's actions are disabled, the alarm actions do not execute when the alarm state changes.

    Args:
        alarm_names(List): The names of the alarms.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.action.disable(ctx, alarm_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.action.disable alarm_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="disable_alarm_actions",
        op_kwargs={"AlarmNames": alarm_names},
    )


async def enable(hub, ctx, alarm_names: List) -> None:
    r"""
    **Autogenerated function**

    Enables the actions for the specified alarms.

    Args:
        alarm_names(List): The names of the alarms.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudwatch.alarm.action.enable(ctx, alarm_names=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudwatch.alarm.action.enable alarm_names=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudwatch",
        operation="enable_alarm_actions",
        op_kwargs={"AlarmNames": alarm_names},
    )
