"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    s3_bucket_name: str,
    s3_key_prefix: str = None,
    sns_topic_name: str = None,
    include_global_service_events: bool = None,
    is_multi_region_trail: bool = None,
    enable_log_file_validation: bool = None,
    cloud_watch_logs_log_group_arn: str = None,
    cloud_watch_logs_role_arn: str = None,
    kms_key_id: str = None,
    is_organization_trail: bool = None,
    tags_list: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.

    Args:
        name(str): Specifies the name of the trail. The name must meet the following requirements:   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)   Start with a letter or number, and end with a letter or number   Be between 3 and 128 characters   Have no adjacent periods, underscores or dashes. Names like my-_namespace and my--namespace are invalid.   Not be in IP address format (for example, 192.168.5.4)  .
        s3_bucket_name(str): Specifies the name of the Amazon S3 bucket designated for publishing log files. See Amazon S3 Bucket Naming Requirements.
        s3_key_prefix(str, optional): Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see Finding Your CloudTrail Log Files. The maximum length is 200 characters. Defaults to None.
        sns_topic_name(str, optional): Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters. Defaults to None.
        include_global_service_events(bool, optional): Specifies whether the trail is publishing events from global services such as IAM to the log files. Defaults to None.
        is_multi_region_trail(bool, optional): Specifies whether the trail is created in the current region or in all regions. The default is false, which creates a trail only in the region where you are signed in. As a best practice, consider creating trails that log events in all regions. Defaults to None.
        enable_log_file_validation(bool, optional): Specifies whether log file integrity validation is enabled. The default is false.  When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail will not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail. . Defaults to None.
        cloud_watch_logs_log_group_arn(str, optional): Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify CloudWatchLogsRoleArn. Defaults to None.
        cloud_watch_logs_role_arn(str, optional): Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. Defaults to None.
        kms_key_id(str, optional): Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier. Examples:   alias/MyAliasName   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012   12345678-1234-1234-1234-123456789012  . Defaults to None.
        is_organization_trail(bool, optional): Specifies whether the trail is created for all accounts in an organization in AWS Organizations, or only for the current AWS account. The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the master account for an organization in AWS Organizations. Defaults to None.
        tags_list(List, optional): A list of tags. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.trail.init.create(
                ctx, name=value, s3_bucket_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.trail.init.create name=value, s3_bucket_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="create_trail",
        op_kwargs={
            "Name": name,
            "S3BucketName": s3_bucket_name,
            "S3KeyPrefix": s3_key_prefix,
            "SnsTopicName": sns_topic_name,
            "IncludeGlobalServiceEvents": include_global_service_events,
            "IsMultiRegionTrail": is_multi_region_trail,
            "EnableLogFileValidation": enable_log_file_validation,
            "CloudWatchLogsLogGroupArn": cloud_watch_logs_log_group_arn,
            "CloudWatchLogsRoleArn": cloud_watch_logs_role_arn,
            "KmsKeyId": kms_key_id,
            "IsOrganizationTrail": is_organization_trail,
            "TagsList": tags_list,
        },
    )


async def delete(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a trail. This operation must be called from the region in which the trail was created. DeleteTrail cannot be called on the shadow trails (replicated trails in other regions) of a trail that is enabled in all regions.

    Args:
        name(str): Specifies the name or the CloudTrail ARN of the trail to be deleted. The format of a trail ARN is: arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.trail.init.delete(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.trail.init.delete name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="delete_trail",
        op_kwargs={"Name": name},
    )


async def describe_all(
    hub, ctx, trail_name_list: List = None, include_shadow_trails: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Retrieves settings for one or more trails associated with the current region for your account.

    Args:
        trail_name_list(List, optional): Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:  arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail  If an empty list is specified, information for the trail in the current region is returned.   If an empty list is specified and IncludeShadowTrails is false, then information for all trails in the current region is returned.   If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the current region and any associated shadow trails in other regions is returned.    If one or more trail names are specified, information is returned only if the names match the names of trails belonging only to the current region. To return information about a trail in another region, you must specify its trail ARN. . Defaults to None.
        include_shadow_trails(bool, optional): Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a trail that was created in a different region, or in the case of an organization trail, the replication of an organization trail in member accounts. If you do not include shadow trails, organization trails in a member account and region replication trails will not be returned. The default is true. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.trail.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.trail.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="describe_trails",
        op_kwargs={
            "trailNameList": trail_name_list,
            "includeShadowTrails": include_shadow_trails,
        },
    )


async def get(hub, ctx, name: str) -> Dict:
    r"""
    **Autogenerated function**

    Returns settings information for a specified trail.

    Args:
        name(str): The name or the Amazon Resource Name (ARN) of the trail for which you want to retrieve settings information.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.trail.init.get(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.trail.init.get name=value
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="cloudtrail", operation="get_trail", op_kwargs={"Name": name}
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists trails that are in the current account.

    Args:
        next_token(str, optional): The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.trail.init.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.trail.init.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="list_trails",
        op_kwargs={"NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    name: str,
    s3_bucket_name: str = None,
    s3_key_prefix: str = None,
    sns_topic_name: str = None,
    include_global_service_events: bool = None,
    is_multi_region_trail: bool = None,
    enable_log_file_validation: bool = None,
    cloud_watch_logs_log_group_arn: str = None,
    cloud_watch_logs_role_arn: str = None,
    kms_key_id: str = None,
    is_organization_trail: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the settings that specify delivery of log files. Changes to a trail do not require stopping the CloudTrail service. Use this action to designate an existing bucket for log delivery. If the existing bucket has previously been a target for CloudTrail log files, an IAM policy exists for the bucket. UpdateTrail must be called from the region in which the trail was created; otherwise, an InvalidHomeRegionException is thrown.

    Args:
        name(str): Specifies the name of the trail or trail ARN. If Name is a trail name, the string must meet the following requirements:   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)   Start with a letter or number, and end with a letter or number   Be between 3 and 128 characters   Have no adjacent periods, underscores or dashes. Names like my-_namespace and my--namespace are invalid.   Not be in IP address format (for example, 192.168.5.4)   If Name is a trail ARN, it must be in the format:  arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .
        s3_bucket_name(str, optional): Specifies the name of the Amazon S3 bucket designated for publishing log files. See Amazon S3 Bucket Naming Requirements. Defaults to None.
        s3_key_prefix(str, optional): Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. For more information, see Finding Your CloudTrail Log Files. The maximum length is 200 characters. Defaults to None.
        sns_topic_name(str, optional): Specifies the name of the Amazon SNS topic defined for notification of log file delivery. The maximum length is 256 characters. Defaults to None.
        include_global_service_events(bool, optional): Specifies whether the trail is publishing events from global services such as IAM to the log files. Defaults to None.
        is_multi_region_trail(bool, optional): Specifies whether the trail applies only to the current region or to all regions. The default is false. If the trail exists only in the current region and this value is set to true, shadow trails (replications of the trail) will be created in the other regions. If the trail exists in all regions and this value is set to false, the trail will remain in the region where it was created, and its shadow trails in other regions will be deleted. As a best practice, consider using trails that log events in all regions. Defaults to None.
        enable_log_file_validation(bool, optional): Specifies whether log file validation is enabled. The default is false.  When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail will not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail. . Defaults to None.
        cloud_watch_logs_log_group_arn(str, optional): Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs will be delivered. Not required unless you specify CloudWatchLogsRoleArn. Defaults to None.
        cloud_watch_logs_role_arn(str, optional): Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. Defaults to None.
        kms_key_id(str, optional): Specifies the KMS key ID to use to encrypt the logs delivered by CloudTrail. The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier. Examples:   alias/MyAliasName   arn:aws:kms:us-east-2:123456789012:alias/MyAliasName   arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012   12345678-1234-1234-1234-123456789012  . Defaults to None.
        is_organization_trail(bool, optional): Specifies whether the trail is applied to all accounts in an organization in AWS Organizations, or only for the current AWS account. The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the master account for an organization in AWS Organizations. If the trail is not an organization trail and this is set to true, the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to false, the trail will remain in the current AWS account but be deleted from all member accounts in the organization. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.trail.init.update(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.trail.init.update name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="update_trail",
        op_kwargs={
            "Name": name,
            "S3BucketName": s3_bucket_name,
            "S3KeyPrefix": s3_key_prefix,
            "SnsTopicName": sns_topic_name,
            "IncludeGlobalServiceEvents": include_global_service_events,
            "IsMultiRegionTrail": is_multi_region_trail,
            "EnableLogFileValidation": enable_log_file_validation,
            "CloudWatchLogsLogGroupArn": cloud_watch_logs_log_group_arn,
            "CloudWatchLogsRoleArn": cloud_watch_logs_role_arn,
            "KmsKeyId": kms_key_id,
            "IsOrganizationTrail": is_organization_trail,
        },
    )
