"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"list_": "list"}


async def add(hub, ctx, resource_id: str, tags_list: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Adds one or more tags to a trail, up to a limit of 50. Overwrites an existing tag's value when a new value is specified for an existing tag key. Tag key names must be unique for a trail; you cannot have two keys with the same name but different values. If you specify a key without a value, the tag will be created with the specified key and a value of null. You can tag a trail that applies to all AWS Regions only from the Region in which the trail was created (also known as its home region).

    Args:
        resource_id(str): Specifies the ARN of the trail to which one or more tags will be added. The format of a trail ARN is:  arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .
        tags_list(List, optional): Contains a list of CloudTrail tags, up to a limit of 50. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.tags.add(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.tags.add resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="add_tags",
        op_kwargs={"ResourceId": resource_id, "TagsList": tags_list},
    )


async def list_(hub, ctx, resource_id_list: List, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the tags for the trail in the current region.

    Args:
        resource_id_list(List): Specifies a list of trail ARNs whose tags will be listed. The list has a limit of 20 ARNs. The format of a trail ARN is:  arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .
        next_token(str, optional): Reserved for future use. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.tags.list(ctx, resource_id_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.tags.list resource_id_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="list_tags",
        op_kwargs={"ResourceIdList": resource_id_list, "NextToken": next_token},
    )


async def remove(hub, ctx, resource_id: str, tags_list: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified tags from a trail.

    Args:
        resource_id(str): Specifies the ARN of the trail from which tags should be removed. The format of a trail ARN is:  arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .
        tags_list(List, optional): Specifies a list of tags to be removed. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.tags.remove(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.tags.remove resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="remove_tags",
        op_kwargs={"ResourceId": resource_id, "TagsList": tags_list},
    )
