"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def list_all(
    hub, ctx, start_time: str = None, end_time: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Returns all public keys whose private keys were used to sign the digest files within the specified time range. The public key is needed to validate digest files that were signed with its corresponding private key.  CloudTrail uses different private/public key pairs per region. Each digest file is signed with a private key unique to its region. Therefore, when you validate a digest file from a particular region, you must look in the same region for its corresponding public key.

    Args:
        start_time(str, optional): Optionally specifies, in UTC, the start of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used, and the current public key is returned. Defaults to None.
        end_time(str, optional): Optionally specifies, in UTC, the end of the time range to look up public keys for CloudTrail digest files. If not specified, the current time is used. Defaults to None.
        next_token(str, optional): Reserved for future use. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.public_key.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.public_key.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="list_public_keys",
        op_kwargs={
            "StartTime": start_time,
            "EndTime": end_time,
            "NextToken": next_token,
        },
    )
