"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get_all(hub, ctx, trail_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Describes the settings for the Insights event selectors that you configured for your trail. GetInsightSelectors shows if CloudTrail Insights event logging is enabled on the trail, and if it is, which insight types are enabled. If you run GetInsightSelectors on a trail that does not have Insights events enabled, the operation throws the exception InsightNotEnabledException  For more information, see Logging CloudTrail Insights Events for Trails  in the AWS CloudTrail User Guide.

    Args:
        trail_name(str): Specifies the name of the trail or trail ARN. If you specify a trail name, the string must meet the following requirements:   Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)   Start with a letter or number, and end with a letter or number   Be between 3 and 128 characters   Have no adjacent periods, underscores or dashes. Names like my-_namespace and my--namespace are not valid.   Not be in IP address format (for example, 192.168.5.4)   If you specify a trail ARN, it must be in the format:  arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.insight_selector.get_all(ctx, trail_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.insight_selector.get_all trail_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="get_insight_selectors",
        op_kwargs={"TrailName": trail_name},
    )


async def put_multiple(hub, ctx, trail_name: str, insight_selectors: List) -> Dict:
    r"""
    **Autogenerated function**

    Lets you enable Insights event logging by specifying the Insights selectors that you want to enable on an existing trail. You also use PutInsightSelectors to turn off Insights event logging, by passing an empty list of insight types. In this release, only ApiCallRateInsight is supported as an Insights selector.

    Args:
        trail_name(str): The name of the CloudTrail trail for which you want to change or add Insights selectors.
        insight_selectors(List): A JSON string that contains the insight types you want to log on a trail. In this release, only ApiCallRateInsight is supported as an insight type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.insight_selector.put_multiple(
                ctx, trail_name=value, insight_selectors=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.insight_selector.put_multiple trail_name=value, insight_selectors=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="put_insight_selectors",
        op_kwargs={"TrailName": trail_name, "InsightSelectors": insight_selectors},
    )
