"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def lookup(
    hub,
    ctx,
    lookup_attributes: List = None,
    start_time: str = None,
    end_time: str = None,
    event_category: str = None,
    max_results: int = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Looks up management events or CloudTrail Insights events that are captured by CloudTrail. You can look up events that occurred in a region within the last 90 days. Lookup supports the following attributes for management events:   AWS access key   Event ID   Event name   Event source   Read only   Resource name   Resource type   User name   Lookup supports the following attributes for Insights events:   Event ID   Event name   Event source   All attributes are optional. The default number of results returned is 50, with a maximum of 50 possible. The response includes a token that you can use to get the next page of results.  The rate of lookup requests is limited to two per second, per account, per region. If this limit is exceeded, a throttling error occurs.

    Args:
        lookup_attributes(List, optional): Contains a list of lookup attributes. Currently the list can contain only one item. Defaults to None.
        start_time(str, optional): Specifies that only events that occur after or at the specified time are returned. If the specified start time is after the specified end time, an error is returned. Defaults to None.
        end_time(str, optional): Specifies that only events that occur before or at the specified time are returned. If the specified end time is before the specified start time, an error is returned. Defaults to None.
        event_category(str, optional): Specifies the event category. If you do not specify an event category, events of the category are not returned in the response. For example, if you do not specify insight as the value of EventCategory, no Insights events are returned. Defaults to None.
        max_results(int, optional): The number of events to return. Possible values are 1 through 50. The default is 50. Defaults to None.
        next_token(str, optional): The token to use to get the next page of results after a previous API call. This token must be passed in with the same parameters that were specified in the the original call. For example, if the original call specified an AttributeKey of 'Username' with a value of 'root', the call with NextToken should include those same parameters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudtrail.event.init.lookup(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudtrail.event.init.lookup
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudtrail",
        operation="lookup_events",
        op_kwargs={
            "LookupAttributes": lookup_attributes,
            "StartTime": start_time,
            "EndTime": end_time,
            "EventCategory": event_category,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )
