"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def build(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Indexes the search suggestions. For more information, see Configuring Suggesters in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.suggester.build(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.suggester.build domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="build_suggesters",
        op_kwargs={"DomainName": domain_name},
    )


async def define(hub, ctx, domain_name: str, suggester: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Configures a suggester for a domain. A suggester enables you to display possible matches before users finish typing their queries. When you configure a suggester, you must specify the name of the text field you want to search for possible matches and a unique name for the suggester. For more information, see Getting Search Suggestions in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        suggester(Dict): Configuration information for a search suggester. Each suggester has a unique name and specifies the text field you want to use for suggestions. The following options can be configured for a suggester: FuzzyMatching, SortExpression. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.suggester.define(
                ctx, domain_name=value, suggester=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.suggester.define domain_name=value, suggester=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="define_suggester",
        op_kwargs={"DomainName": domain_name, "Suggester": suggester},
    )


async def delete(hub, ctx, domain_name: str, suggester_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a suggester. For more information, see Getting Search Suggestions in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        suggester_name(str): Specifies the name of the suggester you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.suggester.delete(
                ctx, domain_name=value, suggester_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.suggester.delete domain_name=value, suggester_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="delete_suggester",
        op_kwargs={"DomainName": domain_name, "SuggesterName": suggester_name},
    )


async def describe_all(
    hub, ctx, domain_name: str, suggester_names: List = None, deployed: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the suggesters configured for a domain. A suggester enables you to display possible matches before users finish typing their queries. Can be limited to specific suggesters by name. By default, shows all suggesters and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see Getting Search Suggestions in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to describe.
        suggester_names(List, optional): The suggesters you want to describe. Defaults to None.
        deployed(bool, optional): Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.suggester.describe_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.suggester.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_suggesters",
        op_kwargs={
            "DomainName": domain_name,
            "SuggesterNames": suggester_names,
            "Deployed": deployed,
        },
    )
