"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, domain_name: str, deployed: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the access policies that control access to the domain's document and search endpoints. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see Configuring Access for a Search Domain in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to describe.
        deployed(bool, optional): Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.service_access_policy.describe_all(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.service_access_policy.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_service_access_policies",
        op_kwargs={"DomainName": domain_name, "Deployed": deployed},
    )


async def update_multiple(hub, ctx, domain_name: str, access_policies: str) -> Dict:
    r"""
    **Autogenerated function**

    Configures the access rules that control access to the domain's document and search endpoints. For more information, see  Configuring Access for an Amazon CloudSearch Domain.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        access_policies(str): The access rules you want to configure. These rules replace any existing rules. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.service_access_policy.update_multiple(
                ctx, domain_name=value, access_policies=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.service_access_policy.update_multiple domain_name=value, access_policies=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="update_service_access_policies",
        op_kwargs={"DomainName": domain_name, "AccessPolicies": access_policies},
    )
