"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def define(hub, ctx, domain_name: str, index_field: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Configures an IndexField for the search domain. Used to create new fields and modify existing ones. You must specify the name of the domain you are configuring and an index field configuration. The index field configuration specifies a unique name, the index field type, and the options you want to configure for the field. The options you can specify depend on the IndexFieldType. If the field exists, the new configuration replaces the old one. For more information, see Configuring Index Fields in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        index_field(Dict): The index field and field options you want to configure. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.index_field.define(
                ctx, domain_name=value, index_field=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.index_field.define domain_name=value, index_field=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="define_index_field",
        op_kwargs={"DomainName": domain_name, "IndexField": index_field},
    )


async def delete(hub, ctx, domain_name: str, index_field_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an IndexField from the search domain. For more information, see Configuring Index Fields in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        index_field_name(str): The name of the index field your want to remove from the domain's indexing options.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.index_field.delete(
                ctx, domain_name=value, index_field_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.index_field.delete domain_name=value, index_field_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="delete_index_field",
        op_kwargs={"DomainName": domain_name, "IndexFieldName": index_field_name},
    )


async def describe_all(
    hub, ctx, domain_name: str, field_names: List = None, deployed: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the index fields configured for the search domain. Can be limited to specific fields by name. By default, shows all fields and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see Getting Domain Information in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to describe.
        field_names(List, optional): A list of the index fields you want to describe. If not specified, information is returned for all configured index fields. Defaults to None.
        deployed(bool, optional): Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.index_field.describe_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.index_field.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_index_fields",
        op_kwargs={
            "DomainName": domain_name,
            "FieldNames": field_names,
            "Deployed": deployed,
        },
    )
