"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def define(hub, ctx, domain_name: str, expression: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Configures an Expression for the search domain. Used to create new expressions and modify existing ones. If the expression exists, the new configuration replaces the old one. For more information, see Configuring Expressions in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        expression(Dict): A named expression that can be evaluated at search time. Can be used to sort the search results, define other expressions, or return computed information in the search results. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.expression.define(
                ctx, domain_name=value, expression=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.expression.define domain_name=value, expression=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="define_expression",
        op_kwargs={"DomainName": domain_name, "Expression": expression},
    )


async def delete(hub, ctx, domain_name: str, expression_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an Expression from the search domain. For more information, see Configuring Expressions in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        expression_name(str): The name of the Expression to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.expression.delete(
                ctx, domain_name=value, expression_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.expression.delete domain_name=value, expression_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="delete_expression",
        op_kwargs={"DomainName": domain_name, "ExpressionName": expression_name},
    )


async def describe_all(
    hub, ctx, domain_name: str, expression_names: List = None, deployed: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the expressions configured for the search domain. Can be limited to specific expressions by name. By default, shows all expressions and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see Configuring Expressions in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to describe.
        expression_names(List, optional): Limits the DescribeExpressions response to the specified expressions. If not specified, all expressions are shown. Defaults to None.
        deployed(bool, optional): Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.expression.describe_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.expression.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_expressions",
        op_kwargs={
            "DomainName": domain_name,
            "ExpressionNames": expression_names,
            "Deployed": deployed,
        },
    )
