"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new search domain. For more information, see Creating a Search Domain in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A name for the domain you are creating. Allowed characters are a-z (lower-case letters), 0-9, and hyphen (-). Domain names must start with a letter or number and be at least 3 and no more than 28 characters long.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.domain.init.create(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.domain.init.create domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="create_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def delete(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Permanently deletes a search domain and all of its data. Once a domain has been deleted, it cannot be recovered. For more information, see Deleting a Search Domain in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to permanently delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.domain.init.delete(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.domain.init.delete domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="delete_domain",
        op_kwargs={"DomainName": domain_name},
    )


async def describe_all(hub, ctx, domain_names: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the search domains owned by this account. Can be limited to specific domains. Shows all domains by default. To get the number of searchable documents in a domain, use the console or submit a matchall request to your domain's search endpoint: q=matchall&amp;q.parser=structured&amp;size=0. For more information, see Getting Information about a Search Domain in the Amazon CloudSearch Developer Guide.

    Args:
        domain_names(List, optional): The names of the domains you want to include in the response. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.domain.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.domain.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_domains",
        op_kwargs={"DomainNames": domain_names},
    )
