"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, domain_name: str, deployed: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Returns the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain.
        deployed(bool, optional): Whether to retrieve the latest configuration (which might be in a Processing state) or the current, active configuration. Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.domain.endpoint_option.describe_all(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.domain.endpoint_option.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_domain_endpoint_options",
        op_kwargs={"DomainName": domain_name, "Deployed": deployed},
    )


async def update_multiple(
    hub, ctx, domain_name: str, domain_endpoint_options: Dict
) -> Dict:
    r"""
    **Autogenerated function**

    Updates the domain's endpoint options, specifically whether all requests to the domain must arrive over HTTPS. For more information, see Configuring Domain Endpoint Options in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain.
        domain_endpoint_options(Dict): Whether to require that all requests to the domain arrive over HTTPS. We recommend Policy-Min-TLS-1-2-2019-07 for TLSSecurityPolicy. For compatibility with older clients, the default is Policy-Min-TLS-1-0-2019-07. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.domain.endpoint_option.update_multiple(
                ctx, domain_name=value, domain_endpoint_options=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.domain.endpoint_option.update_multiple domain_name=value, domain_endpoint_options=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="update_domain_endpoint_options",
        op_kwargs={
            "DomainName": domain_name,
            "DomainEndpointOptions": domain_endpoint_options,
        },
    )
