"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def describe_all(hub, ctx, domain_name: str, deployed: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the availability options configured for a domain. By default, shows the configuration with any pending changes. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see Configuring Availability Options in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to describe.
        deployed(bool, optional): Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.availability_option.describe_all(
                ctx, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.availability_option.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_availability_options",
        op_kwargs={"DomainName": domain_name, "Deployed": deployed},
    )


async def update_multiple(hub, ctx, domain_name: str, multi_az: bool) -> Dict:
    r"""
    **Autogenerated function**

    Configures the availability options for a domain. Enabling the Multi-AZ option expands an Amazon CloudSearch domain to an additional Availability Zone in the same Region to increase fault tolerance in the event of a service disruption. Changes to the Multi-AZ option can take about half an hour to become active. For more information, see Configuring Availability Options in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        multi_az(bool): You expand an existing search domain to a second Availability Zone by setting the Multi-AZ option to true. Similarly, you can turn off the Multi-AZ option to downgrade the domain to a single Availability Zone by setting the Multi-AZ option to false. .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.availability_option.update_multiple(
                ctx, domain_name=value, multi_az=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.availability_option.update_multiple domain_name=value, multi_az=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="update_availability_options",
        op_kwargs={"DomainName": domain_name, "MultiAZ": multi_az},
    )
