"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def define(hub, ctx, domain_name: str, analysis_scheme: Dict) -> Dict:
    r"""
    **Autogenerated function**

    Configures an analysis scheme that can be applied to a text or text-array field to define language-specific text processing options. For more information, see Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        analysis_scheme(Dict): Configuration information for an analysis scheme. Each analysis scheme has a unique name and specifies the language of the text to be processed. The following options can be configured for an analysis scheme: Synonyms, Stopwords, StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.analysis_scheme.define(
                ctx, domain_name=value, analysis_scheme=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.analysis_scheme.define domain_name=value, analysis_scheme=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="define_analysis_scheme",
        op_kwargs={"DomainName": domain_name, "AnalysisScheme": analysis_scheme},
    )


async def delete(hub, ctx, domain_name: str, analysis_scheme_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an analysis scheme. For more information, see Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): A string that represents the name of a domain. Domain names are unique across the domains owned by an account within an AWS region. Domain names start with a letter or number and can contain the following characters: a-z (lowercase), 0-9, and - (hyphen).
        analysis_scheme_name(str): The name of the analysis scheme you want to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.analysis_scheme.delete(
                ctx, domain_name=value, analysis_scheme_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.analysis_scheme.delete domain_name=value, analysis_scheme_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="delete_analysis_scheme",
        op_kwargs={
            "DomainName": domain_name,
            "AnalysisSchemeName": analysis_scheme_name,
        },
    )


async def describe_all(
    hub,
    ctx,
    domain_name: str,
    analysis_scheme_names: List = None,
    deployed: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the analysis schemes configured for a domain. An analysis scheme defines language-specific text processing options for a text field. Can be limited to specific analysis schemes by name. By default, shows all analysis schemes and includes any pending changes to the configuration. Set the Deployed option to true to show the active configuration and exclude pending changes. For more information, see Configuring Analysis Schemes in the Amazon CloudSearch Developer Guide.

    Args:
        domain_name(str): The name of the domain you want to describe.
        analysis_scheme_names(List, optional): The analysis schemes you want to describe. Defaults to None.
        deployed(bool, optional): Whether to display the deployed configuration (true) or include any pending changes (false). Defaults to false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudsearch.analysis_scheme.describe_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudsearch.analysis_scheme.describe_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudsearch",
        operation="describe_analysis_schemes",
        op_kwargs={
            "DomainName": domain_name,
            "AnalysisSchemeNames": analysis_scheme_names,
            "Deployed": deployed,
        },
    )
