"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"list_": "list"}


async def list_(
    hub, ctx, resource_id: str, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a list of tags for the specified AWS CloudHSM cluster. This is a paginated operation, which means that each response might contain only a subset of all the tags. When the response contains only a subset of tags, it includes a NextToken value. Use this value in a subsequent ListTags request to get more tags. When you receive a response with no NextToken (or an empty or null value), that means there are no more tags to get.

    Args:
        resource_id(str): The cluster identifier (ID) for the cluster whose tags you are getting. To find the cluster ID, use DescribeClusters.
        next_token(str, optional): The NextToken value that you received in the previous response. Use this value to get more tags. Defaults to None.
        max_results(int, optional): The maximum number of tags to return in the response. When there are more tags than the number you specify, the response contains a NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.tags.list(ctx, resource_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.tags.list resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="list_tags",
        op_kwargs={
            "ResourceId": resource_id,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )
