"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def tag(hub, ctx, resource_id: str, tag_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Adds or overwrites one or more tags for the specified AWS CloudHSM cluster.

    Args:
        resource_id(str): The cluster identifier (ID) for the cluster that you are tagging. To find the cluster ID, use DescribeClusters.
        tag_list(List): A list of one or more tags.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.resource.tag(ctx, resource_id=value, tag_list=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.resource.tag resource_id=value, tag_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="tag_resource",
        op_kwargs={"ResourceId": resource_id, "TagList": tag_list},
    )


async def untag(hub, ctx, resource_id: str, tag_key_list: List) -> Dict:
    r"""
    **Autogenerated function**

    Removes the specified tag or tags from the specified AWS CloudHSM cluster.

    Args:
        resource_id(str): The cluster identifier (ID) for the cluster whose tags you are removing. To find the cluster ID, use DescribeClusters.
        tag_key_list(List): A list of one or more tag keys for the tags that you are removing. Specify only the tag keys, not the tag values.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.resource.untag(
                ctx, resource_id=value, tag_key_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.resource.untag resource_id=value, tag_key_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="untag_resource",
        op_kwargs={"ResourceId": resource_id, "TagKeyList": tag_key_list},
    )
