"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, cluster_id: str, availability_zone: str, ip_address: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new hardware security module (HSM) in the specified AWS CloudHSM cluster.

    Args:
        cluster_id(str): The identifier (ID) of the HSM's cluster. To find the cluster ID, use DescribeClusters.
        availability_zone(str): The Availability Zone where you are creating the HSM. To find the cluster's Availability Zones, use DescribeClusters.
        ip_address(str, optional): The HSM's IP address. If you specify an IP address, use an available address from the subnet that maps to the Availability Zone where you are creating the HSM. If you don't specify an IP address, one is chosen for you from that subnet. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.hsm.create(
                ctx, cluster_id=value, availability_zone=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.hsm.create cluster_id=value, availability_zone=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="create_hsm",
        op_kwargs={
            "ClusterId": cluster_id,
            "AvailabilityZone": availability_zone,
            "IpAddress": ip_address,
        },
    )


async def delete(
    hub,
    ctx,
    cluster_id: str,
    hsm_id: str = None,
    eni_id: str = None,
    eni_ip: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified HSM. To specify an HSM, you can use its identifier (ID), the IP address of the HSM's elastic network interface (ENI), or the ID of the HSM's ENI. You need to specify only one of these values. To find these values, use DescribeClusters.

    Args:
        cluster_id(str): The identifier (ID) of the cluster that contains the HSM that you are deleting.
        hsm_id(str, optional): The identifier (ID) of the HSM that you are deleting. Defaults to None.
        eni_id(str, optional): The identifier (ID) of the elastic network interface (ENI) of the HSM that you are deleting. Defaults to None.
        eni_ip(str, optional): The IP address of the elastic network interface (ENI) of the HSM that you are deleting. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.hsm.delete(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.hsm.delete cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="delete_hsm",
        op_kwargs={
            "ClusterId": cluster_id,
            "HsmId": hsm_id,
            "EniId": eni_id,
            "EniIp": eni_ip,
        },
    )
