"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    hsm_type: str,
    subnet_ids: List,
    backup_retention_policy: Dict = None,
    source_backup_id: str = None,
    tag_list: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new AWS CloudHSM cluster.

    Args:
        backup_retention_policy(Dict, optional): A policy that defines how the service retains backups. Defaults to None.
        hsm_type(str): The type of HSM to use in the cluster. Currently the only allowed value is hsm1.medium.
        source_backup_id(str, optional): The identifier (ID) of the cluster backup to restore. Use this value to restore the cluster from a backup instead of creating a new cluster. To find the backup ID, use DescribeBackups. Defaults to None.
        subnet_ids(List): The identifiers (IDs) of the subnets where you are creating the cluster. You must specify at least one subnet. If you specify multiple subnets, they must meet the following criteria:   All subnets must be in the same virtual private cloud (VPC).   You can specify only one subnet per Availability Zone.  .
        tag_list(List, optional): Tags to apply to the CloudHSM cluster during creation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.cluster.create(ctx, hsm_type=value, subnet_ids=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.cluster.create hsm_type=value, subnet_ids=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="create_cluster",
        op_kwargs={
            "BackupRetentionPolicy": backup_retention_policy,
            "HsmType": hsm_type,
            "SourceBackupId": source_backup_id,
            "SubnetIds": subnet_ids,
            "TagList": tag_list,
        },
    )


async def delete(hub, ctx, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes the specified AWS CloudHSM cluster. Before you can delete a cluster, you must delete all HSMs in the cluster. To see if the cluster contains any HSMs, use DescribeClusters. To delete an HSM, use DeleteHsm.

    Args:
        cluster_id(str): The identifier (ID) of the cluster that you are deleting. To find the cluster ID, use DescribeClusters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.cluster.delete(ctx, cluster_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.cluster.delete cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="delete_cluster",
        op_kwargs={"ClusterId": cluster_id},
    )


async def describe_all(
    hub, ctx, filters: Dict = None, next_token: str = None, max_results: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about AWS CloudHSM clusters. This is a paginated operation, which means that each response might contain only a subset of all the clusters. When the response contains only a subset of clusters, it includes a NextToken value. Use this value in a subsequent DescribeClusters request to get more clusters. When you receive a response with no NextToken (or an empty or null value), that means there are no more clusters to get.

    Args:
        filters(Dict, optional): One or more filters to limit the items returned in the response. Use the clusterIds filter to return only the specified clusters. Specify clusters by their cluster identifier (ID). Use the vpcIds filter to return only the clusters in the specified virtual private clouds (VPCs). Specify VPCs by their VPC identifier (ID). Use the states filter to return only clusters that match the specified state. Defaults to None.
        next_token(str, optional): The NextToken value that you received in the previous response. Use this value to get more clusters. Defaults to None.
        max_results(int, optional): The maximum number of clusters to return in the response. When there are more clusters than the number you specify, the response contains a NextToken value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.cluster.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.cluster.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="describe_clusters",
        op_kwargs={
            "Filters": filters,
            "NextToken": next_token,
            "MaxResults": max_results,
        },
    )


async def initialize(
    hub, ctx, cluster_id: str, signed_cert: str, trust_anchor: str
) -> Dict:
    r"""
    **Autogenerated function**

    Claims an AWS CloudHSM cluster by submitting the cluster certificate issued by your issuing certificate authority (CA) and the CA's root certificate. Before you can claim a cluster, you must sign the cluster's certificate signing request (CSR) with your issuing CA. To get the cluster's CSR, use DescribeClusters.

    Args:
        cluster_id(str): The identifier (ID) of the cluster that you are claiming. To find the cluster ID, use DescribeClusters.
        signed_cert(str): The cluster certificate issued (signed) by your issuing certificate authority (CA). The certificate must be in PEM format and can contain a maximum of 5000 characters.
        trust_anchor(str): The issuing certificate of the issuing certificate authority (CA) that issued (signed) the cluster certificate. You must use a self-signed certificate. The certificate used to sign the HSM CSR must be directly available, and thus must be the root certificate. The certificate must be in PEM format and can contain a maximum of 5000 characters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.cluster.initialize(
                ctx, cluster_id=value, signed_cert=value, trust_anchor=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.cluster.initialize cluster_id=value, signed_cert=value, trust_anchor=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="initialize_cluster",
        op_kwargs={
            "ClusterId": cluster_id,
            "SignedCert": signed_cert,
            "TrustAnchor": trust_anchor,
        },
    )


async def modify(hub, ctx, backup_retention_policy: Dict, cluster_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Modifies AWS CloudHSM cluster.

    Args:
        backup_retention_policy(Dict): A policy that defines how the service retains backups.
        cluster_id(str): The identifier (ID) of the cluster that you want to modify. To find the cluster ID, use DescribeClusters.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.cluster.modify(
                ctx, backup_retention_policy=value, cluster_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.cluster.modify backup_retention_policy=value, cluster_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="modify_cluster",
        op_kwargs={
            "BackupRetentionPolicy": backup_retention_policy,
            "ClusterId": cluster_id,
        },
    )
