"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def copy(
    hub, ctx, destination_region: str, backup_id: str, tag_list: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Copy an AWS CloudHSM cluster backup to a different region.

    Args:
        destination_region(str): The AWS region that will contain your copied CloudHSM cluster backup.
        backup_id(str): The ID of the backup that will be copied to the destination region. .
        tag_list(List, optional): Tags to apply to the destination backup during creation. If you specify tags, only these tags will be applied to the destination backup. If you do not specify tags, the service copies tags from the source backup to the destination backup. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.backup.to_region.copy(
                ctx, destination_region=value, backup_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.backup.to_region.copy destination_region=value, backup_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="copy_backup_to_region",
        op_kwargs={
            "DestinationRegion": destination_region,
            "BackupId": backup_id,
            "TagList": tag_list,
        },
    )
