"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, backup_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Deletes a specified AWS CloudHSM backup. A backup can be restored up to 7 days after the DeleteBackup request is made. For more information on restoring a backup, see RestoreBackup.

    Args:
        backup_id(str): The ID of the backup to be deleted. To find the ID of a backup, use the DescribeBackups operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.backup.init.delete(ctx, backup_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.backup.init.delete backup_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="delete_backup",
        op_kwargs={"BackupId": backup_id},
    )


async def describe_all(
    hub,
    ctx,
    next_token: str = None,
    max_results: int = None,
    filters: Dict = None,
    sort_ascending: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about backups of AWS CloudHSM clusters. This is a paginated operation, which means that each response might contain only a subset of all the backups. When the response contains only a subset of backups, it includes a NextToken value. Use this value in a subsequent DescribeBackups request to get more backups. When you receive a response with no NextToken (or an empty or null value), that means there are no more backups to get.

    Args:
        next_token(str, optional): The NextToken value that you received in the previous response. Use this value to get more backups. Defaults to None.
        max_results(int, optional): The maximum number of backups to return in the response. When there are more backups than the number you specify, the response contains a NextToken value. Defaults to None.
        filters(Dict, optional): One or more filters to limit the items returned in the response. Use the backupIds filter to return only the specified backups. Specify backups by their backup identifier (ID). Use the sourceBackupIds filter to return only the backups created from a source backup. The sourceBackupID of a source backup is returned by the CopyBackupToRegion operation. Use the clusterIds filter to return only the backups for the specified clusters. Specify clusters by their cluster identifier (ID). Use the states filter to return only backups that match the specified state. Use the neverExpires filter to return backups filtered by the value in the neverExpires parameter. True returns all backups exempt from the backup retention policy. False returns all backups with a backup retention policy defined at the cluster. Defaults to None.
        sort_ascending(bool, optional): Designates whether or not to sort the return backups by ascending chronological order of generation. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.backup.init.describe_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.backup.init.describe_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="describe_backups",
        op_kwargs={
            "NextToken": next_token,
            "MaxResults": max_results,
            "Filters": filters,
            "SortAscending": sort_ascending,
        },
    )


async def restore(hub, ctx, backup_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Restores a specified AWS CloudHSM backup that is in the PENDING_DELETION state. For mor information on deleting a backup, see DeleteBackup.

    Args:
        backup_id(str): The ID of the backup to be restored. To find the ID of a backup, use the DescribeBackups operation.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.backup.init.restore(ctx, backup_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.backup.init.restore backup_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="restore_backup",
        op_kwargs={"BackupId": backup_id},
    )
