"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def modify(hub, ctx, backup_id: str, never_expires: bool) -> Dict:
    r"""
    **Autogenerated function**

    Modifies attributes for AWS CloudHSM backup.

    Args:
        backup_id(str): The identifier (ID) of the backup to modify. To find the ID of a backup, use the DescribeBackups operation.
        never_expires(bool): Specifies whether the service should exempt a backup from the retention policy for the cluster. True exempts a backup from the retention policy. False means the service applies the backup retention policy defined at the cluster.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsmv2.backup.attribute.modify(
                ctx, backup_id=value, never_expires=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsmv2.backup.attribute.modify backup_id=value, never_expires=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsmv2",
        operation="modify_backup_attributes",
        op_kwargs={"BackupId": backup_id, "NeverExpires": never_expires},
    )
