"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def remove(hub, ctx, resource_arn: str, tag_key_list: List) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Removes one or more tags from the specified AWS CloudHSM resource. To remove a tag, specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use AddTagsToResource.

    Args:
        resource_arn(str): The Amazon Resource Name (ARN) of the AWS CloudHSM resource.
        tag_key_list(List): The tag key or keys to remove. Specify only the tag key to remove (not the value). To overwrite the value for an existing tag, use AddTagsToResource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.tags.from_resource.remove(
                ctx, resource_arn=value, tag_key_list=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.tags.from_resource.remove resource_arn=value, tag_key_list=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="remove_tags_from_resource",
        op_kwargs={"ResourceArn": resource_arn, "TagKeyList": tag_key_list},
    )
