"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, certificate: str, label: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Creates an HSM client.

    Args:
        label(str, optional): The label for the client. Defaults to None.
        certificate(str): The contents of a Base64-Encoded X.509 v3 certificate to be installed on the HSMs used by this client.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.luna_client.create(ctx, certificate=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.luna_client.create certificate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="create_luna_client",
        op_kwargs={"Label": label, "Certificate": certificate},
    )


async def delete(hub, ctx, client_arn: str) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Deletes a client.

    Args:
        client_arn(str): The ARN of the client to delete.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.luna_client.delete(ctx, client_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.luna_client.delete client_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="delete_luna_client",
        op_kwargs={"ClientArn": client_arn},
    )


async def describe(
    hub, ctx, client_arn: str = None, certificate_fingerprint: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Retrieves information about an HSM client.

    Args:
        client_arn(str, optional): The ARN of the client. Defaults to None.
        certificate_fingerprint(str, optional): The certificate fingerprint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.luna_client.describe(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.luna_client.describe
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="describe_luna_client",
        op_kwargs={
            "ClientArn": client_arn,
            "CertificateFingerprint": certificate_fingerprint,
        },
    )


async def list_all(hub, ctx, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Lists all of the clients. This operation supports pagination with the use of the NextToken member. If more results are available, the NextToken member of the response contains a token that you pass in the next call to ListLunaClients to retrieve the next set of items.

    Args:
        next_token(str, optional): The NextToken value from a previous call to ListLunaClients. Pass null if this is the first call. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.luna_client.list_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.luna_client.list_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="list_luna_clients",
        op_kwargs={"NextToken": next_token},
    )


async def modify(hub, ctx, client_arn: str, certificate: str) -> Dict:
    r"""
    **Autogenerated function**

    This is documentation for AWS CloudHSM Classic. For more information, see AWS CloudHSM Classic FAQs, the AWS CloudHSM Classic User Guide, and the AWS CloudHSM Classic API Reference.  For information about the current version of AWS CloudHSM, see AWS CloudHSM, the AWS CloudHSM User Guide, and the AWS CloudHSM API Reference. Modifies the certificate used by the client. This action can potentially start a workflow to install the new certificate on the client's HSMs.

    Args:
        client_arn(str): The ARN of the client.
        certificate(str): The new certificate for the client.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.cloudhsm.luna_client.modify(
                ctx, client_arn=value, certificate=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.cloudhsm.luna_client.modify client_arn=value, certificate=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="cloudhsm",
        operation="modify_luna_client",
        op_kwargs={"ClientArn": client_arn, "Certificate": certificate},
    )
